/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.el.GreekRedundancyRule;
import org.languagetool.rules.el.GreekSpecificCaseRule;
import org.languagetool.rules.el.GreekWordRepeatBeginningRule;
import org.languagetool.rules.el.MorfologikGreekSpellerRule;
import org.languagetool.rules.el.NumeralStressRule;
import org.languagetool.rules.el.ReplaceHomonymsRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.el.GreekSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.el.GreekTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.el.GreekWordTokenizer;

public class Greek
extends Language {
    public String getShortCode() {
        return "el";
    }

    public String getName() {
        return "Greek";
    }

    public String[] getCountries() {
        return new String[]{"GR"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Panagiotis Minos")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"\u03a4\u03bf \u03ba\u03cc\u03bc\u03bc\u03b1 \u03c7\u03c9\u03c1\u03af\u03b6\u03b5\u03b9 \u03c0\u03c1\u03bf\u03c4\u03ac\u03c3\u03b5\u03b9\u03c2<marker> ,</marker> \u03cc\u03c1\u03bf\u03c5\u03c2 \u03c0\u03c1\u03bf\u03c4\u03ac\u03c3\u03b5\u03c9\u03bd \u03ba\u03b1\u03b9 \u03c6\u03c1\u03ac\u03c3\u03b5\u03b9\u03c2."), Example.fixed((String)"\u03a4\u03bf \u03ba\u03cc\u03bc\u03bc\u03b1 \u03c7\u03c9\u03c1\u03af\u03b6\u03b5\u03b9 \u03c0\u03c1\u03bf\u03c4\u03ac\u03c3\u03b5\u03b9\u03c2<marker>,</marker> \u03cc\u03c1\u03bf\u03c5\u03c2 \u03c0\u03c1\u03bf\u03c4\u03ac\u03c3\u03b5\u03c9\u03bd \u03ba\u03b1\u03b9 \u03c6\u03c1\u03ac\u03c3\u03b5\u03b9\u03c2.")), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule("EL_UNPAIRED_BRACKETS", messages, Arrays.asList("[", "(", "{", "\u201c", "\"", "\u00ab"), Arrays.asList("]", ")", "}", "\u201d", "\"", "\u00bb")), new LongSentenceRule(messages, userConfig, 50), new MorfologikGreekSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"\u0397 \u03c4\u03b5\u03bb\u03b5\u03af\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03b7\u03bc\u03b5\u03af\u03bf \u03c3\u03c4\u03af\u03be\u03b7\u03c2. <marker>\u03b4\u03b5\u03af\u03c7\u03bd\u03b5\u03b9</marker> \u03c4\u03bf \u03c4\u03ad\u03bb\u03bf\u03c2 \u03bc\u03af\u03b1\u03c2 \u03c0\u03c1\u03cc\u03c4\u03b1\u03c3\u03b7\u03c2."), Example.fixed((String)"\u0397 \u03c4\u03b5\u03bb\u03b5\u03af\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03b7\u03bc\u03b5\u03af\u03bf \u03c3\u03c4\u03af\u03be\u03b7\u03c2. <marker>\u0394\u03b5\u03af\u03c7\u03bd\u03b5\u03b9</marker> \u03c4\u03bf \u03c4\u03ad\u03bb\u03bf\u03c2 \u03bc\u03af\u03b1\u03c2 \u03c0\u03c1\u03cc\u03c4\u03b1\u03c3\u03b7\u03c2.")), new MultipleWhitespaceRule(messages, (Language)this), new GreekWordRepeatBeginningRule(messages, this), new WordRepeatRule(messages, (Language)this), new ReplaceHomonymsRule(messages, this), new GreekSpecificCaseRule(messages), new NumeralStressRule(messages), new GreekRedundancyRule(messages, this)});
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new GreekTagger();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new GreekWordTokenizer();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new GreekSynthesizer(this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new XmlRuleDisambiguator((Language)this);
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikGreekSpellerRule(messages, this, null, null);
    }
}

