/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.el;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class GreekWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADD_ADVERBS = new HashSet<String>();
    private static final Set<String> CONTRAST_ADVERBS = new HashSet<String>();
    private static final Set<String> EXPLAIN_ADVERBS = new HashSet<String>();

    public GreekWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"\u0395\u03c0\u03af\u03c3\u03b7\u03c2, \u03c0\u03b1\u03af\u03b6\u03c9 \u03c0\u03bf\u03b4\u03cc\u03c3\u03c6\u03b1\u03b9\u03c1\u03bf. <marker>\u0395\u03c0\u03af\u03c3\u03b7\u03c2</marker>, \u03c0\u03b1\u03af\u03b6\u03c9 \u03bc\u03c0\u03ac\u03c3\u03ba\u03b5\u03c4."), Example.fixed((String)"\u0395\u03c0\u03af\u03c3\u03b7\u03c2, \u03c0\u03b1\u03af\u03b6\u03c9 \u03c0\u03bf\u03b4\u03cc\u03c3\u03c6\u03b1\u03b9\u03c1\u03bf. <marker>\u0395\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd</marker>, \u03c0\u03b1\u03af\u03b6\u03c9 \u03bc\u03c0\u03ac\u03c3\u03ba\u03b5\u03c4."));
    }

    public String getId() {
        return "GREEK_WORD_REPEAT_BEGINNING_RULE";
    }

    public boolean isException(String token) {
        return super.isException(token) || token.equals("\u039f") || token.equals("\u0397") || token.equals("\u03a4\u03bf") || token.equals("\u039f\u03b9") || token.equals("\u03a4\u03b1") || token.equals("\u0388\u03bd\u03b1\u03c2") || token.equals("\u039c\u03af\u03b1") || token.equals("\u0388\u03bd\u03b1");
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADD_ADVERBS.contains(token.getToken()) || CONTRAST_ADVERBS.contains(token.getToken()) || EXPLAIN_ADVERBS.contains(token.getToken());
    }

    protected List<String> getSuggestions(AnalyzedTokenReadings token) {
        String tok = token.getToken();
        if (ADD_ADVERBS.contains(tok)) {
            return ADD_ADVERBS.stream().filter(adv -> !adv.equals(tok)).collect(Collectors.toList());
        }
        if (CONTRAST_ADVERBS.contains(tok)) {
            return CONTRAST_ADVERBS.stream().filter(adv -> !adv.equals(tok)).collect(Collectors.toList());
        }
        if (EXPLAIN_ADVERBS.contains(tok)) {
            return EXPLAIN_ADVERBS.stream().filter(adv -> !adv.equals(tok)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static {
        ADD_ADVERBS.add("\u0395\u03c0\u03af\u03c3\u03b7\u03c2");
        ADD_ADVERBS.add("\u0395\u03c0\u03b9\u03c0\u03c1\u03cc\u03c3\u03b8\u03b5\u03c4\u03b1");
        ADD_ADVERBS.add("\u0391\u03ba\u03cc\u03bc\u03b7");
        ADD_ADVERBS.add("\u0395\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd");
        ADD_ADVERBS.add("\u03a3\u03c5\u03bc\u03c0\u03bb\u03b7\u03c1\u03c9\u03bc\u03b1\u03c4\u03b9\u03ba\u03ac");
        CONTRAST_ADVERBS.add("\u0391\u03bd\u03c4\u03af\u03b8\u03b5\u03c4\u03b1");
        CONTRAST_ADVERBS.add("\u03a9\u03c3\u03c4\u03cc\u03c3\u03bf");
        CONTRAST_ADVERBS.add("\u0395\u03bd\u03c4\u03bf\u03cd\u03c4\u03bf\u03b9\u03c2");
        CONTRAST_ADVERBS.add("\u0395\u03be\u03ac\u03bb\u03bb\u03bf\u03c5");
        EXPLAIN_ADVERBS.add("\u0394\u03b7\u03bb\u03b1\u03b4\u03ae");
        EXPLAIN_ADVERBS.add("\u0395\u03b9\u03b4\u03b9\u03ba\u03cc\u03c4\u03b5\u03c1\u03b1");
        EXPLAIN_ADVERBS.add("\u0395\u03b9\u03b4\u03b9\u03ba\u03ac");
        EXPLAIN_ADVERBS.add("\u03a3\u03c5\u03b3\u03ba\u03b5\u03ba\u03c1\u03b9\u03bc\u03ad\u03bd\u03b1");
    }
}

