/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.es.SpanishSynthesizer;
import org.languagetool.tagging.es.SpanishTagger;

public class SimpleReplaceVerbsRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceVerbsRule.loadFromPath((String)"/es/replace_verbs.txt");
    private static final Locale ES_LOCALE = new Locale("ES");
    private static final String endings = "a|aba|abais|aban|abas|ad|ada|adas|ado|ados|amos|an|ando|ar|ara|arais|aran|aras|are|areis|aremos|aren|ares|aron|ar\u00e1|ar\u00e1n|ar\u00e1s|ar\u00e9|ar\u00e9is|ar\u00eda|ar\u00edais|ar\u00edamos|ar\u00edan|ar\u00edas|as|ase|aseis|asen|ases|aste|asteis|e|emos|en|es|o|\u00e1bamos|\u00e1is|\u00e1ramos|\u00e1remos|\u00e1semos|\u00e9|\u00e9is|\u00f3|arse|arme|arte|arlos|arles|arlas|arnos|aros";
    private static final Pattern desinencies_1conj_0 = Pattern.compile("(.+?)(a|aba|abais|aban|abas|ad|ada|adas|ado|ados|amos|an|ando|ar|ara|arais|aran|aras|are|areis|aremos|aren|ares|aron|ar\u00e1|ar\u00e1n|ar\u00e1s|ar\u00e9|ar\u00e9is|ar\u00eda|ar\u00edais|ar\u00edamos|ar\u00edan|ar\u00edas|as|ase|aseis|asen|ases|aste|asteis|e|emos|en|es|o|\u00e1bamos|\u00e1is|\u00e1ramos|\u00e1remos|\u00e1semos|\u00e9|\u00e9is|\u00f3|arse|arme|arte|arlos|arles|arlas|arnos|aros)");
    private static final Pattern desinencies_1conj_1 = Pattern.compile("(.+)(a|aba|abais|aban|abas|ad|ada|adas|ado|ados|amos|an|ando|ar|ara|arais|aran|aras|are|areis|aremos|aren|ares|aron|ar\u00e1|ar\u00e1n|ar\u00e1s|ar\u00e9|ar\u00e9is|ar\u00eda|ar\u00edais|ar\u00edamos|ar\u00edan|ar\u00edas|as|ase|aseis|asen|ases|aste|asteis|e|emos|en|es|o|\u00e1bamos|\u00e1is|\u00e1ramos|\u00e1remos|\u00e1semos|\u00e9|\u00e9is|\u00f3|arse|arme|arte|arlos|arles|arlas|arnos|aros)");
    private SpanishTagger tagger;
    private SpanishSynthesizer synth;

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceVerbsRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setIgnoreTaggedWords();
        super.useSubRuleSpecificIds();
        this.tagger = (SpanishTagger)language.getTagger();
        this.synth = (SpanishSynthesizer)language.getSynthesizer();
    }

    public final String getId() {
        return "ES_SIMPLE_REPLACE_VERBS";
    }

    public String getDescription() {
        return "Detecta verbos incorrectos y propone sugerencias.";
    }

    public String getShort() {
        return "Verbo incorrecto";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Verbo incorrecto.";
    }

    public Locale getLocale() {
        return ES_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            Object wordAsArray;
            String originalTokenStr = tokenReadings.getToken();
            if (this.ignoreTaggedWords && tokenReadings.isTagged()) continue;
            String tokenString = originalTokenStr.toLowerCase(this.getLocale());
            AnalyzedTokenReadings analyzedTokenReadings = null;
            String infinitive = null;
            for (int i = 0; i < 2 && analyzedTokenReadings == null; ++i) {
                List<AnalyzedTokenReadings> analyzedTokenReadingsList;
                Matcher m = i == 0 ? desinencies_1conj_0.matcher(tokenString) : desinencies_1conj_1.matcher(tokenString);
                if (!m.matches()) continue;
                String lexeme = m.group(1);
                String desinence = m.group(2);
                if (desinence.startsWith("e") || desinence.startsWith("\u00e9") || desinence.startsWith("i") || desinence.startsWith("\u00ef")) {
                    if (lexeme.endsWith("c")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("z");
                    } else if (lexeme.endsWith("qu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("c");
                    } else if (lexeme.endsWith("g")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("j");
                    } else if (lexeme.endsWith("g\u00fc")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("gu");
                    } else if (lexeme.endsWith("gu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("g");
                    }
                }
                if (!wrongWords.containsKey(infinitive = lexeme.concat("ar")) || (analyzedTokenReadingsList = this.tagger.tag((List<String>)(wordAsArray = Arrays.asList("am".concat(desinence))))).get(0).getAnalyzedToken(0).getPOSTag() == null) continue;
                analyzedTokenReadings = analyzedTokenReadingsList.get(0);
            }
            if (analyzedTokenReadings == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            String[] synthesized = null;
            List<String> replacementInfinitives = wrongWords.get(infinitive);
            wordAsArray = replacementInfinitives.iterator();
            while (wordAsArray.hasNext()) {
                String replacementInfinitive = wordAsArray.next();
                if (replacementInfinitive.startsWith("(")) {
                    possibleReplacements.add(replacementInfinitive);
                    continue;
                }
                String[] parts = replacementInfinitive.split(" ");
                AnalyzedToken infinitiveAsAnTkn = new AnalyzedToken(parts[0], "V.*", parts[0]);
                for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
                    try {
                        String POSTag = analyzedToken.getPOSTag();
                        if (infinitiveAsAnTkn.getLemma().equals("haver")) {
                            POSTag = "VA" + POSTag.substring(2);
                        }
                        synthesized = this.synth.synthesize(infinitiveAsAnTkn, POSTag);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not synthesize: " + infinitiveAsAnTkn + " with tag " + analyzedToken.getPOSTag(), e);
                    }
                    for (String s : synthesized) {
                        for (int j = 1; j < parts.length; ++j) {
                            s = s.concat(" ").concat(parts[j]);
                        }
                        if (possibleReplacements.contains(s)) continue;
                        possibleReplacements.add(s);
                    }
                }
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, possibleReplacements, sentence, infinitive);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

