/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class SpanishWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADD_ADVERBS = new HashSet<String>();
    private static final Set<String> CONTRAST_CONJ = new HashSet<String>();
    private static final Set<String> EMPHASIS_ADVERBS = new HashSet<String>();
    private static final Set<String> EXPLAIN_ADVERBS = new HashSet<String>();
    private static final Set<String> PERSONAL_PRONOUNS = new HashSet<String>();
    private static final List<String> ADD_EXPRESSIONS = Arrays.asList("As\u00ed mismo");
    private static final List<String> CONTRAST_EXPRESSIONS = Arrays.asList("Aun as\u00ed", "Por otra parte", "Sin embargo");
    private static final List<String> EXCEPCIONS_START = Arrays.asList("el", "la", "los", "las", "punto", "art\u00edculo", "m\u00f3dulo", "parte", "sesi\u00f3n", "unidad", "tema", "n");

    public SpanishWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setTags(Collections.singletonList(Tag.picky));
        this.addExamplePair(Example.wrong((String)"Asimismo, la calle es casi toda residencial. <marker>Asimismo</marker>, lleva el nombre de un poeta."), Example.fixed((String)"Adem\u00e1s, la calle es casi toda residencal. Tambi\u00e9n lleva el nombre de un poeta."));
    }

    public String getId() {
        return "SPANISH_WORD_REPEAT_BEGINNING_RULE";
    }

    public boolean isException(String token) {
        return super.isException(token) || Character.isDigit(token.charAt(0)) || EXCEPCIONS_START.contains(token.toLowerCase());
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        if (token.hasPosTag("RG") || token.hasPosTag("LOC_ADV")) {
            return true;
        }
        String tok = token.getToken();
        return ADD_ADVERBS.contains(tok) || CONTRAST_CONJ.contains(tok) || EMPHASIS_ADVERBS.contains(tok) || EXPLAIN_ADVERBS.contains(tok);
    }

    protected List<String> getSuggestions(AnalyzedTokenReadings token) {
        String tok = token.getToken();
        String lowerTok = tok.toLowerCase();
        if (PERSONAL_PRONOUNS.contains(lowerTok)) {
            return Arrays.asList("Adem\u00e1s, " + lowerTok, "Igualmente, " + lowerTok, "No solo eso, sino que " + lowerTok);
        }
        if (ADD_ADVERBS.contains(tok)) {
            List<String> addSuggestions = this.getDifferentAdverbsOfSameCategory(tok, ADD_ADVERBS);
            addSuggestions.addAll(ADD_EXPRESSIONS);
            return addSuggestions;
        }
        if (CONTRAST_CONJ.contains(tok)) {
            List<String> contrastSuggestions = CONTRAST_EXPRESSIONS;
            return contrastSuggestions;
        }
        if (EMPHASIS_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EMPHASIS_ADVERBS);
        }
        if (EXPLAIN_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EXPLAIN_ADVERBS);
        }
        return Collections.emptyList();
    }

    private List<String> getDifferentAdverbsOfSameCategory(String adverb, Set<String> adverbsOfCategory) {
        return adverbsOfCategory.stream().filter(adv -> !adv.equals(adverb)).collect(Collectors.toList());
    }

    static {
        ADD_ADVERBS.add("Asimismo");
        ADD_ADVERBS.add("Igualmente");
        ADD_ADVERBS.add("Adem\u00e1s");
        ADD_ADVERBS.add("Tambi\u00e9n");
        ADD_ADVERBS.add("Adicionalmente");
        CONTRAST_CONJ.add("Pero");
        CONTRAST_CONJ.add("Empero");
        CONTRAST_CONJ.add("Mas");
        EMPHASIS_ADVERBS.add("Obviamente");
        EMPHASIS_ADVERBS.add("Claramente");
        EMPHASIS_ADVERBS.add("Absolutamente");
        EMPHASIS_ADVERBS.add("Definitivamente");
        EXPLAIN_ADVERBS.add("Espec\u00edficamente");
        EXPLAIN_ADVERBS.add("Concretamente");
        EXPLAIN_ADVERBS.add("Particularmente");
        EXPLAIN_ADVERBS.add("Precisamente");
        PERSONAL_PRONOUNS.add("yo");
        PERSONAL_PRONOUNS.add("t\u00fa");
        PERSONAL_PRONOUNS.add("\u00e9l");
        PERSONAL_PRONOUNS.add("ella");
        PERSONAL_PRONOUNS.add("nosostros");
        PERSONAL_PRONOUNS.add("nosotras");
        PERSONAL_PRONOUNS.add("vosotros");
        PERSONAL_PRONOUNS.add("vosotras");
        PERSONAL_PRONOUNS.add("ellos");
        PERSONAL_PRONOUNS.add("ellas");
        PERSONAL_PRONOUNS.add("usted");
        PERSONAL_PRONOUNS.add("ustedes");
    }
}

