/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class TextToNumberFilter
extends RuleFilter {
    private static Map<String, Float> numbers = new HashMap<String, Float>();
    private static Map<String, Float> multipliers = new HashMap<String, Float>();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        int posWord = 0;
        float total = 0.0f;
        float current = 0.0f;
        float totalDecimal = 0.0f;
        float currentDecimal = 0.0f;
        int addedZeros = 0;
        boolean percentage = false;
        boolean decimal = false;
        while (posWord < patternTokens.length && patternTokens[posWord].getEndPos() <= match.getToPos()) {
            if (patternTokens[posWord].getStartPos() >= match.getFromPos() && patternTokens[posWord].getEndPos() <= match.getToPos()) {
                String form = patternTokens[posWord].getToken().toLowerCase();
                if (posWord > 0 && form.equals("ciento") && patternTokens[posWord - 1].getToken().toLowerCase().equals("por")) {
                    percentage = true;
                    break;
                }
                if (form.equals("coma")) {
                    decimal = true;
                    ++posWord;
                    continue;
                }
                if (!decimal) {
                    if (numbers.containsKey(form)) {
                        current += numbers.get(form).floatValue();
                    } else if (multipliers.containsKey(form)) {
                        if (current == 0.0f) {
                            current = 1.0f;
                        }
                        total += current * multipliers.get(form).floatValue();
                        current = 0.0f;
                    }
                } else if (numbers.containsKey(form)) {
                    int zerosToAdd = TextToNumberFilter.format(numbers.get(form).floatValue(), false).length();
                    currentDecimal = (float)((double)currentDecimal + (double)numbers.get(form).floatValue() / Math.pow(10.0, addedZeros + zerosToAdd));
                    ++addedZeros;
                }
            }
            ++posWord;
        }
        total += current;
        RuleMatch ruleMatch = match;
        String sugg = TextToNumberFilter.format(total += (totalDecimal += currentDecimal), percentage);
        ruleMatch.addSuggestedReplacement(sugg);
        return ruleMatch;
    }

    private static String format(float d, boolean percentage) {
        String result = d == (float)((long)d) ? String.format("%d", (long)d) : String.format("%s", Float.valueOf(d));
        if (percentage) {
            result = result + "\u202f%";
        }
        return result;
    }

    static {
        numbers.put("cero", Float.valueOf(0.0f));
        numbers.put("medio", Float.valueOf(0.5f));
        numbers.put("un", Float.valueOf(1.0f));
        numbers.put("uno", Float.valueOf(1.0f));
        numbers.put("una", Float.valueOf(1.0f));
        numbers.put("dos", Float.valueOf(2.0f));
        numbers.put("tres", Float.valueOf(3.0f));
        numbers.put("cuatro", Float.valueOf(4.0f));
        numbers.put("cinco", Float.valueOf(5.0f));
        numbers.put("seis", Float.valueOf(6.0f));
        numbers.put("siete", Float.valueOf(7.0f));
        numbers.put("ocho", Float.valueOf(8.0f));
        numbers.put("nueve", Float.valueOf(9.0f));
        numbers.put("diez", Float.valueOf(10.0f));
        numbers.put("once", Float.valueOf(11.0f));
        numbers.put("doce", Float.valueOf(12.0f));
        numbers.put("trece", Float.valueOf(13.0f));
        numbers.put("catorce", Float.valueOf(14.0f));
        numbers.put("quince", Float.valueOf(15.0f));
        numbers.put("diecis\u00e9is", Float.valueOf(16.0f));
        numbers.put("diecisiete", Float.valueOf(17.0f));
        numbers.put("dieciocho", Float.valueOf(18.0f));
        numbers.put("diecinueve", Float.valueOf(19.0f));
        numbers.put("veinte", Float.valueOf(20.0f));
        numbers.put("veintiuno", Float.valueOf(21.0f));
        numbers.put("veintid\u00f3s", Float.valueOf(22.0f));
        numbers.put("veintitr\u00e9s", Float.valueOf(23.0f));
        numbers.put("veinticuatro", Float.valueOf(24.0f));
        numbers.put("veinticinco", Float.valueOf(25.0f));
        numbers.put("veintis\u00e9is", Float.valueOf(26.0f));
        numbers.put("veintisiete", Float.valueOf(27.0f));
        numbers.put("veintiocho", Float.valueOf(28.0f));
        numbers.put("veintinueve", Float.valueOf(29.0f));
        numbers.put("treinta", Float.valueOf(30.0f));
        numbers.put("cuarenta", Float.valueOf(40.0f));
        numbers.put("cincuenta", Float.valueOf(50.0f));
        numbers.put("sesenta", Float.valueOf(60.0f));
        numbers.put("setenta", Float.valueOf(70.0f));
        numbers.put("ochenta", Float.valueOf(80.0f));
        numbers.put("noventa", Float.valueOf(90.0f));
        numbers.put("cien", Float.valueOf(100.0f));
        numbers.put("ciento", Float.valueOf(100.0f));
        numbers.put("doscientos", Float.valueOf(200.0f));
        numbers.put("trescientos", Float.valueOf(300.0f));
        numbers.put("cuatrocientos", Float.valueOf(400.0f));
        numbers.put("quinientos", Float.valueOf(500.0f));
        numbers.put("seiscientos", Float.valueOf(600.0f));
        numbers.put("setecientos", Float.valueOf(700.0f));
        numbers.put("ochocientos", Float.valueOf(800.0f));
        numbers.put("novecientos", Float.valueOf(900.0f));
        numbers.put("doscientas", Float.valueOf(200.0f));
        numbers.put("trescientas", Float.valueOf(300.0f));
        numbers.put("cuatrocientas", Float.valueOf(400.0f));
        numbers.put("quinientas", Float.valueOf(500.0f));
        numbers.put("seiscientas", Float.valueOf(600.0f));
        numbers.put("setecientas", Float.valueOf(700.0f));
        numbers.put("ochocientas", Float.valueOf(800.0f));
        numbers.put("novecientas", Float.valueOf(900.0f));
        multipliers.put("mil", Float.valueOf(1000.0f));
        multipliers.put("mill\u00f3n", Float.valueOf(1000000.0f));
        multipliers.put("millones", Float.valueOf(1000000.0f));
        multipliers.put("bill\u00f3n", Float.valueOf(1.0E13f));
        multipliers.put("billones", Float.valueOf(1.0E13f));
        multipliers.put("trill\u00f3n", Float.valueOf(1.0E19f));
        multipliers.put("trillones", Float.valueOf(1.0E19f));
    }
}

