/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.fr.QuestionWhitespaceRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.fr.FrenchHybridDisambiguator;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class French
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Tagger tagger;
    private Disambiguator disambiguator;
    private String name = "French";

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "fr";
    }

    public String[] getCountries() {
        return new String[]{"FR", "", "BE", "CH", "CA", "LU", "MC", "CM", "CI", "HI", "ML", "SN", "CD", "MA", "RE"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new FrenchTagger();
        }
        return this.tagger;
    }

    public final Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new FrenchSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new FrenchHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Contributor[] getMaintainers() {
        Contributor hVoisard = new Contributor("Hugo Voisard");
        hVoisard.setRemark("2006-2007");
        return new Contributor[]{Contributors.DOMINIQUE_PELLE, new Contributor("Agnes Souque"), hVoisard};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, (Language)this), new HunspellNoSuggestionRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new QuestionWhitespaceRule(messages)});
    }
}

