/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.fr.CompoundRule;
import org.languagetool.rules.fr.FrenchCompoundAwareHunspellRule;
import org.languagetool.rules.fr.FrenchConfusionProbabilityRule;
import org.languagetool.rules.fr.GrammalecteRule;
import org.languagetool.rules.fr.QuestionWhitespaceRule;
import org.languagetool.rules.fr.QuestionWhitespaceStrictRule;
import org.languagetool.rules.fr.SimpleReplaceRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.fr.FrenchHybridDisambiguator;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.fr.FrenchWordTokenizer;

public class French
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "French";
    }

    public String getShortCode() {
        return "fr";
    }

    public String[] getCountries() {
        return new String[]{"FR", "", "BE", "CH", "CA", "LU", "MC", "CM", "CI", "HT", "ML", "SN", "CD", "MA", "RE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new FrenchTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new FrenchSynthesizer(this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new FrenchWordTokenizer();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new FrenchHybridDisambiguator();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.DOMINIQUE_PELLE};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, false), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{"), Arrays.asList("]", ")", "}")), new FrenchCompoundAwareHunspellRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new CompoundRule(messages), new QuestionWhitespaceStrictRule(messages, this), new QuestionWhitespaceRule(messages, this), new SimpleReplaceRule(messages)});
    }

    public List<Rule> getRelevantRulesGlobalConfig(ResourceBundle messages, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (globalConfig != null && globalConfig.getGrammalecteServer() != null) {
            rules.add(new GrammalecteRule(messages, globalConfig));
        }
        return rules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new FrenchConfusionProbabilityRule(messages, languageModel, this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "CEST_A_DIRE": {
                return 10;
            }
            case "ESPACE_UNITES": {
                return 1;
            }
            case "BYTES": {
                return 1;
            }
            case "Y_A": {
                return 1;
            }
            case "A_A_ACCENT": {
                return 1;
            }
            case "FRENCH_WHITESPACE_STRICT": {
                return 1;
            }
            case "FRENCH_WHITESPACE": {
                return 0;
            }
            case "ELISION": {
                return 0;
            }
            case "JE_SUI": {
                return 1;
            }
        }
        if (id.startsWith("grammalecte_")) {
            return -1;
        }
        return super.getPriorityForId(id);
    }
}

