/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.Example;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.CompoundWordTokenizer;

public class FrenchCompoundAwareHunspellRule
extends CompoundAwareHunspellRule {
    private static final Tagger tagger = Languages.getLanguageForShortCode((String)"fr").getTagger();
    private static final Pattern vocalPattern = Pattern.compile("[dDLl]['\u2019\u2032][Hh]?[a\u00e0\u00e2\u00e4e\u00e9\u00e8\u00ea\u00ebi\u00ee\u00efo\u00f6\u00f4uyA\u00c0\u00c2\u00c4E\u00c9\u00c8\u00ca\u00cbI\u00ce\u00cfO\u00d6\u00d4UY].*");

    public FrenchCompoundAwareHunspellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) {
        super(messages, language, (CompoundWordTokenizer)new NonSplittingTokenizer(), FrenchCompoundAwareHunspellRule.getSpeller(language, userConfig, null), userConfig, altLanguages);
        this.addExamplePair(Example.wrong((String)"Le <marker>chein</marker> noir"), Example.fixed((String)"Le <marker>chien</marker> noir"));
    }

    public String getId() {
        return "FR_SPELLING_RULE";
    }

    protected void filterForLanguage(List<String> suggestions) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MorfologikMultiSpeller getSpeller(Language language, UserConfig userConfig, String languageVariantPlainTextDict) {
        try {
            String langCode = language.getShortCode();
            String morfoFile = "/" + langCode + "/hunspell/" + langCode + "_" + language.getCountries()[0] + ".dict";
            if (!JLanguageTool.getDataBroker().resourceExists(morfoFile)) return null;
            List paths = FrenchCompoundAwareHunspellRule.getSpellingFilePaths((String)langCode);
            List streams = FrenchCompoundAwareHunspellRule.getStreams((List)paths);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), StandardCharsets.UTF_8));){
                MorfologikMultiSpeller morfologikMultiSpeller = new MorfologikMultiSpeller(morfoFile, br, paths, null, languageVariantPlainTextDict, userConfig != null ? userConfig.getAcceptedWords() : Collections.emptyList(), 2);
                return morfologikMultiSpeller;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        String s = null;
        switch (word) {
            case "Jai": {
                s = "J'ai";
                break;
            }
            case "jai": {
                s = "j'ai";
                break;
            }
            case "Etais-tu": {
                s = "\u00c9tais-tu";
                break;
            }
            case "etais-tu": {
                s = "\u00e9tais-tu";
                break;
            }
            case "Etes-vous": {
                s = "\u00cates-vous";
                break;
            }
            case "etes-vous": {
                s = "\u00eates-vous";
                break;
            }
            case "Etiez-vous": {
                s = "\u00catiez-vous";
                break;
            }
            case "etiez-vous": {
                s = "\u00eatiez-vous";
                break;
            }
            case "Etait-ce": {
                s = "\u00c9tait-ce";
                break;
            }
            case "etait-ce": {
                s = "\u00e9tait-ce";
                break;
            }
            case "Etait-il": {
                s = "\u00c9tait-il";
                break;
            }
            case "etait-il": {
                s = "\u00e9tait-il";
                break;
            }
            case "Depeche-toi": {
                s = "D\u00e9p\u00eache-toi";
                break;
            }
            case "depeche-toi": {
                s = "d\u00e9p\u00eache-toi";
                break;
            }
            case "preferes-tu": {
                s = "pr\u00e9f\u00e8res-tu";
                break;
            }
            case "Preferes-tu": {
                s = "Pr\u00e9f\u00e8res-tu";
                break;
            }
            case "la-bas": {
                s = "l\u00e0-bas";
                break;
            }
            case "la-dedans": {
                s = "l\u00e0-dedans";
                break;
            }
            case "la-dessus": {
                s = "l\u00e0-dessus";
            }
        }
        if (s == null) {
            return SuggestedReplacement.convert(Collections.emptyList());
        }
        return SuggestedReplacement.convert(Collections.singletonList(s));
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(StringUtils.uncapitalize((String)words.get(0)));
        return ignore || ignoreUncapitalizedWord;
    }

    protected boolean ignoreWord(String word) throws IOException {
        Matcher matcher;
        boolean ignore = super.ignoreWord(word);
        if (ignore) {
            return true;
        }
        if (word.length() > 3 && (matcher = vocalPattern.matcher(word)).matches()) {
            List readings = tagger.tag(Collections.singletonList(word.substring(2)));
            return readings.stream().anyMatch(k -> k.hasPosTagStartingWith("N ") || k.hasPosTagStartingWith("Z "));
        }
        return false;
    }

    static class NonSplittingTokenizer
    implements CompoundWordTokenizer {
        NonSplittingTokenizer() {
        }

        public List<String> tokenize(String text) {
            return Collections.singletonList(text);
        }
    }
}

