/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.French;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;

public class AnglicismReplaceRule
extends AbstractSimpleReplaceRule2 {
    private static final String FILE_NAME = "/fr/replace_anglicism.txt";
    private static final Locale FR_LOCALE = new Locale("FR");

    public AnglicismReplaceRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new French());
        super.setCategory(new Category(new CategoryId("CAT_ANGLICISMES"), this.getDescription()));
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public final String getId() {
        return "FR_SIMPLE_REPLACE_ANGLICISM";
    }

    public String getDescription() {
        return "Anglicismes (calques, emprunts directs, etc.)";
    }

    public String getShort() {
        return "Anglicismes";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return FR_LOCALE;
    }

    public List<String> getFileNames() {
        return Arrays.asList(FILE_NAME);
    }

    public String getSuggestion() {
        return "Alternatives possibles pour cet anglicisme :";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return null;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("Z") || atr.isImmunized() || atr.isIgnoredBySpeller();
    }
}

