/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.language.French;
import org.languagetool.rules.AbstractFindSuggestionsFilter;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.fr.MorfologikFrenchSpellerRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tools.StringTools;

public class FindSuggestionsFilter
extends AbstractFindSuggestionsFilter {
    private static MorfologikFrenchSpellerRule morfologikRule;
    private final FrenchSynthesizer synth = new FrenchSynthesizer(new French());

    public FindSuggestionsFilter() throws IOException {
        if (morfologikRule == null) {
            ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale("fr"));
            morfologikRule = new MorfologikFrenchSpellerRule(messages, new French(), null, Collections.emptyList());
        }
    }

    protected Tagger getTagger() {
        return FrenchTagger.INSTANCE;
    }

    protected Synthesizer getSynthesizer() {
        return this.synth;
    }

    protected List<String> getSpellingSuggestions(AnalyzedTokenReadings atr) throws IOException {
        String w = atr.isTagged() ? StringTools.makeWrong((String)atr.getToken()) : atr.getToken();
        ArrayList<String> suggestions = new ArrayList<String>();
        ArrayList<String> wordsToCheck = new ArrayList<String>();
        wordsToCheck.add(w);
        if (w.endsWith("s")) {
            wordsToCheck.add(w.substring(0, w.length() - 1));
        }
        if (w.matches("[aeiou\u00e9]$")) {
            wordsToCheck.add(w + "s");
        }
        for (String word : wordsToCheck) {
            AnalyzedTokenReadings[] atk = new AnalyzedTokenReadings[1];
            AnalyzedToken token = new AnalyzedToken(word, null, null);
            atk[0] = new AnalyzedTokenReadings(token);
            AnalyzedSentence sentence = new AnalyzedSentence(atk);
            RuleMatch[] matches = morfologikRule.match(sentence);
            if (matches.length <= 0) continue;
            suggestions.addAll(matches[0].getSuggestedReplacements());
        }
        return suggestions;
    }

    protected String cleanSuggestion(String s) {
        String output = s.replaceAll("^[smntl]'|^(nous|vous|le|la|les|me|te|se|leur|en|y) ", "");
        output = output.split(" ")[0];
        return output;
    }
}

