/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.tools.StringTools;

public class WordWithDeterminerFilter
extends RuleFilter {
    private static final String determinerRegexp = "(P.)?D .*|J .*|V.* ppa .*";
    private static final Pattern DETERMINER = Pattern.compile("(P.)?D .*|J .*|V.* ppa .*");
    private static final String wordRegexp = "[ZNJ] .*|V.* ppa .*";
    private static final Pattern WORD = Pattern.compile("[ZNJ] .*|V.* ppa .*");
    private static final String[] GenderNumber = new String[]{"([me]) (s|sp)", "([fe]) (s|sp)", "([me]) (p|sp)", "([fe]) (p|sp)"};
    private static final String determiner = "((P.)?D |J |V.* ppa )";
    private static final List<String> exceptionsDeterminer = Arrays.asList("bels", "fols", "mols", "nouvels");
    private static final JLanguageTool lt = Languages.getLanguageForShortCode((String)"fr").createDefaultJLanguageTool();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        for (Rule r : lt.getAllRules()) {
            if (r.getCategory().getId().toString().equals("CAT_ELISION") || r.getId().equals("CET_CE") || r.getId().equals("CE_CET") || r.getId().equals("MA_VOYELLE") || r.getId().equals("MON_NFS") || r.getId().equals("VIEUX")) {
                lt.enableRule(r.getId());
                continue;
            }
            lt.disableRule(r.getId());
        }
        String wordFrom = this.getRequired("wordFrom", arguments);
        String determinerFrom = this.getRequired("determinerFrom", arguments);
        int posWord = 0;
        int posDeterminer = 0;
        if (wordFrom != null && determinerFrom != null) {
            posWord = Integer.parseInt(wordFrom);
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("WordWithDeterminerFilter: Index out of bounds in " + match.getRule().getFullId() + ", wordFrom: " + posWord);
            }
            posDeterminer = Integer.parseInt(determinerFrom);
            if (posDeterminer < 1 || posDeterminer > patternTokens.length) {
                throw new IllegalArgumentException("WordWithDeterminerFilter: Index out of bounds in " + match.getRule().getFullId() + ", posDeterminer: " + posWord);
            }
        } else {
            throw new IllegalArgumentException("WordWithDeterminerFilter: undefined parameters wordFrom or determinerFrom in " + match.getRule().getFullId());
        }
        AnalyzedTokenReadings atrDeterminer = patternTokens[posDeterminer - 1];
        AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
        boolean isDeterminerCapitalized = StringTools.isCapitalizedWord((String)atrDeterminer.getToken());
        boolean isWordCapitalized = StringTools.isCapitalizedWord((String)atrWord.getToken());
        boolean isDeterminerAllupper = StringTools.isAllUppercase((String)atrDeterminer.getToken()) && !atrDeterminer.getToken().equalsIgnoreCase("L'");
        boolean isWordAllupper = StringTools.isAllUppercase((String)atrWord.getToken());
        AnalyzedToken atDeterminer = this.getAnalyzedToken(atrDeterminer, DETERMINER);
        AnalyzedToken atWord = this.getAnalyzedToken(atrWord, WORD);
        if (atWord == null || atDeterminer == null) {
            throw new RuntimeException("Error analyzing sentence: '" + match.getSentence().getText() + "' with rule " + match.getRule().getFullId());
        }
        boolean isNoun = atWord.getPOSTag().startsWith("N") || atWord.getPOSTag().startsWith("Z");
        boolean isAdjective = atWord.getPOSTag().startsWith("J");
        String prefix = "[ZNJ] ";
        if (isNoun && !isAdjective) {
            prefix = "[NZ] ";
        } else if (!isNoun && isAdjective) {
            prefix = "J ";
        }
        String[][] determinerForms = new String[4][];
        String[][] wordForms = new String[4][];
        for (int i = 0; i < 4; ++i) {
            determinerForms[i] = FrenchSynthesizer.INSTANCE.synthesize(atDeterminer, determiner + GenderNumber[i], true);
            wordForms[i] = FrenchSynthesizer.INSTANCE.synthesize(atWord, prefix + GenderNumber[i], true);
            if (determinerForms[i].length == 0 && atDeterminer.getPOSTag().matches(".+" + GenderNumber[i])) {
                determinerForms[i] = new String[]{atDeterminer.getToken()};
            }
            if (wordForms[i].length != 0 || !atWord.getPOSTag().matches(".+" + GenderNumber[i])) continue;
            wordForms[i] = new String[]{atWord.getToken()};
        }
        ArrayList<String> replacements = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            for (int cw = 0; cw < wordForms[i].length; ++cw) {
                for (int cd = 0; cd < determinerForms[i].length; ++cd) {
                    if (exceptionsDeterminer.contains(determinerForms[i][cd]) || determinerForms[i][cd] == null || wordForms[i][cw] == null) continue;
                    String determiner = determinerForms[i][cd];
                    String word = wordForms[i][cw];
                    if (isDeterminerCapitalized) {
                        determiner = StringTools.uppercaseFirstChar((String)determiner);
                    }
                    if (isWordCapitalized) {
                        word = StringTools.uppercaseFirstChar((String)word);
                    }
                    if (isDeterminerAllupper) {
                        determiner = determiner.toUpperCase();
                    }
                    if (isWordAllupper) {
                        word = word.toUpperCase();
                    }
                    String r = determiner + " " + word;
                    List matches = lt.check(r = r.replace("' ", "'"));
                    if (matches.size() != 0 || replacements.contains(r)) continue;
                    if (r.endsWith(atWord.getToken())) {
                        replacements.add(0, r);
                        continue;
                    }
                    replacements.add(r);
                }
            }
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        replacements.addAll(0, match.getSuggestedReplacements());
        if (!replacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(replacements);
        }
        return ruleMatch;
    }

    private AnalyzedToken getAnalyzedToken(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return analyzedToken;
        }
        return null;
    }
}

