/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.Arrays;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.fr.QuestionWhitespaceRule;

public class QuestionWhitespaceStrictRule
extends QuestionWhitespaceRule {
    public QuestionWhitespaceStrictRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.setTags(Arrays.asList(Tag.picky));
        this.setDefaultTempOff();
    }

    @Override
    public String getId() {
        return "FRENCH_WHITESPACE_STRICT";
    }

    @Override
    public String getDescription() {
        return "Insertion des espaces fines ins\u00e9cables";
    }

    @Override
    protected boolean isAllowedWhitespaceChar(AnalyzedTokenReadings[] tokens, int i) {
        if (i < 0) {
            return false;
        }
        return tokens[i].getToken().equals("\u202f") || tokens[i].getToken().equals("\u00a0") || !tokens[i].isWhitespace();
    }
}

