/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.fr;

import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.French;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

public class FrenchHybridDisambiguator
extends AbstractDisambiguator {
    private final MultiWordChunker chunker = new MultiWordChunker("/fr/multiwords.txt", true, true, false);
    private final Disambiguator disambiguator = new XmlRuleDisambiguator((Language)new French(), true);
    private final MultiWordChunker chunkerGlobal = new MultiWordChunker("/spelling_global.txt", false, true, false, MultiWordChunker.tagForNotAddingTags);

    public FrenchHybridDisambiguator() {
        this.chunker.setRemovePreviousTags(true);
        this.chunkerGlobal.setIgnoreSpelling(true);
    }

    public AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        return this.disambiguate(input, null);
    }

    public AnalyzedSentence disambiguate(AnalyzedSentence input, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        return this.disambiguator.disambiguate(this.chunker.disambiguate(this.chunkerGlobal.disambiguate(input, checkCanceled), checkCanceled), checkCanceled);
    }
}

