/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.FrenchSynthesizer;

public class PostponedAdjectiveConcordanceFilter
extends RuleFilter {
    private final int maxLevels = 4;
    private static final Pattern NOM = Pattern.compile("[NZ] .*");
    private static final Pattern NOM_MS = Pattern.compile("[NZ] m s");
    private static final Pattern NOM_FS = Pattern.compile("[NZ] f s");
    private static final Pattern NOM_MP = Pattern.compile("[NZ] m p");
    private static final Pattern NOM_MN = Pattern.compile("[NZ] m sp");
    private static final Pattern NOM_FP = Pattern.compile("[NZ] f p");
    private static final Pattern NOM_CS = Pattern.compile("[NZ] e s");
    private static final Pattern NOM_CP = Pattern.compile("[NZ] e sp");
    private static final Pattern NOM_DET = Pattern.compile("[NZ] .*|(P\\+)?D .*");
    private static final Pattern _GN_ = Pattern.compile("_GN_.*");
    private static final Pattern _GN_MS = Pattern.compile("_GN_MS");
    private static final Pattern _GN_FS = Pattern.compile("_GN_FS");
    private static final Pattern _GN_MP = Pattern.compile("_GN_MP");
    private static final Pattern _GN_FP = Pattern.compile("_GN_FP");
    private static final Pattern _GN_CS = Pattern.compile("_GN_[MF]S");
    private static final Pattern _GN_CP = Pattern.compile("_GN_[MF]P");
    private static final Pattern _GN_MN = Pattern.compile("_GN_M[SP]");
    private static final Pattern _GN_FN = Pattern.compile("_GN_F[SP]");
    private static final Pattern DET = Pattern.compile("(P\\+)?D .*");
    private static final Pattern DET_CS = Pattern.compile("(P\\+)?D e s");
    private static final Pattern DET_MS = Pattern.compile("(P\\+)?D m s");
    private static final Pattern DET_FS = Pattern.compile("(P\\+)?D f s");
    private static final Pattern DET_MP = Pattern.compile("(P\\+)?D m p");
    private static final Pattern DET_FP = Pattern.compile("(P\\+)?D f p");
    private static final Pattern DET_CP = Pattern.compile("(P\\+)?D e p");
    private static final Pattern GN_MS = Pattern.compile("[NZ] [me] (s|sp)|J [me] (s|sp)|V ppa m s|(P\\+)?D m (s|sp)");
    private static final Pattern GN_FS = Pattern.compile("[NZ] [fe] (s|sp)|J [fe] (s|sp)|V ppa f s|(P\\+)?D f (s|sp)");
    private static final Pattern GN_MP = Pattern.compile("[NZ] [me] (p|sp)|J [me] (p|sp)|V ppa m p|(P\\+)?D m (p|sp)");
    private static final Pattern GN_FP = Pattern.compile("[NZ] [fe] (p|sp)|J [fe] (p|sp)|V ppa f p|(P\\+)?D f (p|sp)");
    private static final Pattern GN_CP = Pattern.compile("[NZ] [fme] (p|sp)|J [fme] (p|sp)|(P\\+)?D [fme] (p|sp)");
    private static final Pattern GN_CS = Pattern.compile("[NZ] [fme] (s|sp)|J [fme] (s|sp)|(P\\+)?D [fme] (s|sp)");
    private static final Pattern GN_MN = Pattern.compile("[NZ] [me] (s|p|sp)|J [me] (s|p|sp)|(P\\+)?D [me] (s|p|sp)");
    private static final Pattern GN_FN = Pattern.compile("[NZ] [fe] (s|p|sp)|J [fe] (s|p|sp)|(P\\+)?D [fe] (s|p|sp)");
    private static final Pattern ADJECTIU = Pattern.compile("J .*|V ppa .*|PX.*");
    private static final Pattern ADJECTIU_MS = Pattern.compile("J [me] (s|sp)|V ppa m s");
    private static final Pattern ADJECTIU_FS = Pattern.compile("J [fe] (s|sp)|V ppa f s");
    private static final Pattern ADJECTIU_MP = Pattern.compile("J [me] (p|sp)|V ppa m p");
    private static final Pattern ADJECTIU_FP = Pattern.compile("J [fe] (p|sp)|V ppa f p");
    private static final Pattern ADJECTIU_CP = Pattern.compile("J e (p|sp)");
    private static final Pattern ADJECTIU_CS = Pattern.compile("J e (s|sp)");
    private static final Pattern ADJECTIU_MN = Pattern.compile("J m sp");
    private static final Pattern ADJECTIU_FN = Pattern.compile("J f sp");
    private static final Pattern ADJECTIU_S = Pattern.compile("J .* (s|sp)|V ppa . s");
    private static final Pattern ADJECTIU_P = Pattern.compile("J .* (p|sp)|V ppa . p");
    private static final Pattern ADJECTIU_M = Pattern.compile("J [me] .*|V ppa [me] .*");
    private static final Pattern ADJECTIU_F = Pattern.compile("J [fe] .*|V ppa [fe] .*");
    private static final Pattern ADVERBI = Pattern.compile("A");
    private static final Pattern CONJUNCIO = Pattern.compile("C .*");
    private static final Pattern PUNTUACIO = Pattern.compile("_PUNCT");
    private static final Pattern LOC_ADV = Pattern.compile("A");
    private static final Pattern ADVERBIS_ACCEPTATS = Pattern.compile("A");
    private static final Pattern COORDINACIO_IONI = Pattern.compile("et|ou|ni");
    private static final Pattern KEEP_COUNT = Pattern.compile("Y|J .*|N .*|D .*|P.*|V ppa .*|M nonfin|UNKNOWN|Z.*|V.* inf|V ppr");
    private static final Pattern KEEP_COUNT2 = Pattern.compile(",|et|ou|ni");
    private static final Pattern STOP_COUNT = Pattern.compile("[;:\\(\\)\\[\\]\u2013\u2014\u2015\u2012]");
    private static final Pattern PREPOSICIONS = Pattern.compile("P.*");
    private static final Pattern PREPOSICIO_CANVI_NIVELL = Pattern.compile("d'|de|des|du|\u00e0|au|aux|en|dans|sur|entre|par|pour|avec|sans|contre|comme");
    private static final Pattern VERB = Pattern.compile("V.* (inf|ind|sub|con|ppr|imp).*");
    private static final Pattern INFINITIVE = Pattern.compile("V.* inf");
    private static final Pattern GV = Pattern.compile("_GV_");
    boolean adverbAppeared = false;
    boolean conjunctionAppeared = false;
    boolean punctuationAppeared = false;
    boolean infinitiveAppeared = false;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        int i = patternTokenPos;
        boolean isPlural = true;
        boolean isPrevNoun = false;
        Pattern substPattern = null;
        Pattern gnPattern = null;
        Pattern adjPattern = null;
        boolean canBeMS = false;
        boolean canBeFS = false;
        boolean canBeMP = false;
        boolean canBeFP = false;
        boolean canBeP = false;
        int[] cNt = new int[4];
        int[] cNMS = new int[4];
        int[] cNFS = new int[4];
        int[] cNMP = new int[4];
        int[] cNMN = new int[4];
        int[] cNFP = new int[4];
        int[] cNCS = new int[4];
        int[] cNCP = new int[4];
        int[] cDMS = new int[4];
        int[] cDFS = new int[4];
        int[] cDMP = new int[4];
        int[] cDFP = new int[4];
        int[] cN = new int[4];
        int[] cD = new int[4];
        int level = 0;
        int j = 1;
        this.initializeApparitions();
        while (i - j > 0 && this.keepCounting(tokens[i - j]) && level < 4) {
            if (!isPrevNoun) {
                if (this.matchPostagRegexp(tokens[i - j], NOM) || i - j - 1 > 0 && !this.matchPostagRegexp(tokens[i - j], NOM) && this.matchPostagRegexp(tokens[i - j], ADJECTIU) && this.matchPostagRegexp(tokens[i - j - 1], DET)) {
                    if (this.matchPostagRegexp(tokens[i - j], _GN_MS)) {
                        int n = level;
                        cNMS[n] = cNMS[n] + 1;
                        canBeMS = true;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], _GN_FS)) {
                        int n = level;
                        cNFS[n] = cNFS[n] + 1;
                        canBeFS = true;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], _GN_MP)) {
                        int n = level;
                        cNMP[n] = cNMP[n] + 1;
                        canBeMP = true;
                    }
                    if (this.matchPostagRegexp(tokens[i - j], _GN_FP)) {
                        int n = level;
                        cNFP[n] = cNFP[n] + 1;
                        canBeFP = true;
                    }
                }
                if (!this.matchPostagRegexp(tokens[i - j], _GN_)) {
                    if (this.matchPostagRegexp(tokens[i - j], NOM_MS)) {
                        int n = level;
                        cNMS[n] = cNMS[n] + 1;
                        canBeMS = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_FS)) {
                        int n = level;
                        cNFS[n] = cNFS[n] + 1;
                        canBeFS = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_MP)) {
                        int n = level;
                        cNMP[n] = cNMP[n] + 1;
                        canBeMP = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_MN)) {
                        int n = level;
                        cNMN[n] = cNMN[n] + 1;
                        canBeMS = true;
                        canBeMP = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_FP)) {
                        int n = level;
                        cNFP[n] = cNFP[n] + 1;
                        canBeFP = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_CS)) {
                        int n = level;
                        cNCS[n] = cNCS[n] + 1;
                        canBeMS = true;
                        canBeFS = true;
                    } else if (this.matchPostagRegexp(tokens[i - j], NOM_CP)) {
                        int n = level;
                        cNCP[n] = cNCP[n] + 1;
                        canBeFP = true;
                        canBeMP = true;
                    }
                }
            }
            if (this.matchPostagRegexp(tokens[i - j], NOM)) {
                int n = level;
                cNt[n] = cNt[n] + 1;
                isPrevNoun = true;
            } else {
                isPrevNoun = false;
            }
            if (this.matchPostagRegexp(tokens[i - j], DET_CS)) {
                if (this.matchPostagRegexp(tokens[i - j + 1], NOM_MS)) {
                    int n = level;
                    cDMS[n] = cDMS[n] + 1;
                    canBeMS = true;
                }
                if (this.matchPostagRegexp(tokens[i - j + 1], NOM_FS)) {
                    int n = level;
                    cDFS[n] = cDFS[n] + 1;
                    canBeFS = true;
                }
            }
            if (this.matchPostagRegexp(tokens[i - j], DET_CP)) {
                if (this.matchPostagRegexp(tokens[i - j + 1], NOM_MP)) {
                    int n = level;
                    cDMS[n] = cDMS[n] + 1;
                    canBeMP = true;
                }
                if (this.matchPostagRegexp(tokens[i - j + 1], NOM_FP)) {
                    int n = level;
                    cDFS[n] = cDFS[n] + 1;
                    canBeFP = true;
                }
            }
            if (!this.matchPostagRegexp(tokens[i - j], ADVERBI)) {
                if (this.matchPostagRegexp(tokens[i - j], DET_MS)) {
                    int n = level;
                    cDMS[n] = cDMS[n] + 1;
                    canBeMS = true;
                }
                if (this.matchPostagRegexp(tokens[i - j], DET_FS)) {
                    int n = level;
                    cDFS[n] = cDFS[n] + 1;
                    canBeFS = true;
                }
                if (this.matchPostagRegexp(tokens[i - j], DET_MP)) {
                    int n = level;
                    cDMP[n] = cDMP[n] + 1;
                    canBeMP = true;
                }
                if (this.matchPostagRegexp(tokens[i - j], DET_FP)) {
                    int n = level;
                    cDFP[n] = cDFP[n] + 1;
                    canBeFP = true;
                }
            }
            if (i - j - 1 > 0) {
                if (this.matchRegexp(tokens[i - j].getToken(), PREPOSICIO_CANVI_NIVELL) && this.matchPostagRegexp(tokens[i - j], PREPOSICIONS) && !this.matchPostagRegexp(tokens[i - j], CONJUNCIO) && !this.matchRegexp(tokens[i - j - 1].getToken(), COORDINACIO_IONI) && !this.matchPostagRegexp(tokens[i - j + 1], ADVERBI)) {
                    ++level;
                } else if (tokens[i - j].getToken().equalsIgnoreCase("d'") && tokens[i - j + 1].getToken().equalsIgnoreCase("environ")) {
                    ++level;
                }
            }
            j = this.updateJValue(tokens, i, j, level);
            this.updateApparitions(tokens[i - j]);
            ++j;
        }
        if (++level > 4) {
            level = 4;
        }
        int cNtotal = 0;
        int cDtotal = 0;
        for (j = 0; j < level; ++j) {
            cN[j] = cNMS[j] + cNFS[j] + cNMP[j] + cNFP[j] + cNCS[j] + cNCP[j] + cNMN[j];
            cD[j] = cDMS[j] + cDFS[j] + cDMP[j] + cDFP[j];
            cNtotal += cN[j];
            cDtotal += cD[j];
            if (this.matchPostagRegexp(tokens[i], ADJECTIU_MP) && (cN[j] > 1 || cD[j] > 1) && cNMS[j] + cNMN[j] + cNMP[j] + cNCS[j] + cNCP[j] + cDMS[j] + cDMP[j] > 0 && cNFS[j] + cNFP[j] <= cNt[j]) {
                return null;
            }
            if (this.matchPostagRegexp(tokens[i], ADJECTIU_FP) && (cN[j] > 1 || cD[j] > 1) && (cNMS[j] + cNMP[j] + cNMN[j] + cDMS[j] + cDMP[j] == 0 || cNt[j] > 0 && cNFS[j] + cNFP[j] >= cNt[j])) {
                return null;
            }
            if (cN[j] + cD[j] <= 0) continue;
            isPlural = isPlural && cD[j] > 1 && level > 1;
            canBeP = canBeP || cN[j] > 1;
        }
        boolean bl = isPlural = isPlural || i - 2 > 0 && cNMP[0] + cNFP[0] + cNCP[0] > 0 && tokens[i - 2].getToken().equals(",");
        if (cNtotal == 0 && cDtotal == 0) {
            return null;
        }
        if (this.matchPostagRegexp(tokens[i], ADJECTIU_CS)) {
            substPattern = GN_CS;
            adjPattern = ADJECTIU_S;
            gnPattern = _GN_CS;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_CP)) {
            substPattern = GN_CP;
            adjPattern = ADJECTIU_P;
            gnPattern = _GN_CP;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_MN)) {
            substPattern = GN_MN;
            adjPattern = ADJECTIU_M;
            gnPattern = _GN_MN;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_FN)) {
            substPattern = GN_FN;
            adjPattern = ADJECTIU_FN;
            gnPattern = _GN_FN;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_MS)) {
            substPattern = GN_MS;
            adjPattern = ADJECTIU_MS;
            gnPattern = _GN_MS;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_FS)) {
            substPattern = GN_FS;
            adjPattern = ADJECTIU_FS;
            gnPattern = _GN_FS;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_MP)) {
            substPattern = GN_MP;
            adjPattern = ADJECTIU_MP;
            gnPattern = _GN_MP;
        } else if (this.matchPostagRegexp(tokens[i], ADJECTIU_FP)) {
            substPattern = GN_FP;
            adjPattern = ADJECTIU_FP;
            gnPattern = _GN_FP;
        }
        if (substPattern == null || gnPattern == null || adjPattern == null) {
            return null;
        }
        j = 1;
        boolean keepCount = true;
        while (i - j > 0 && keepCount) {
            if (this.matchPostagRegexp(tokens[i - j], NOM_DET) && this.matchPostagRegexp(tokens[i - j], gnPattern)) {
                return null;
            }
            if (!this.matchPostagRegexp(tokens[i - j], _GN_) && this.matchPostagRegexp(tokens[i - j], substPattern)) {
                return null;
            }
            keepCount = !this.matchPostagRegexp(tokens[i - j], NOM_DET);
            ++j;
        }
        if (!(this.matchPostagRegexp(tokens[i - 1], NOM) && !this.matchPostagRegexp(tokens[i - 1], substPattern) || this.matchPostagRegexp(tokens[i - 1], _GN_) && !this.matchPostagRegexp(tokens[i - 1], gnPattern) || this.matchPostagRegexp(tokens[i - 1], ADJECTIU) && !this.matchPostagRegexp(tokens[i - 1], adjPattern) || i > 2 && this.matchPostagRegexp(tokens[i - 1], ADVERBIS_ACCEPTATS) && !this.matchPostagRegexp(tokens[i - 2], VERB) && !this.matchPostagRegexp(tokens[i - 2], PREPOSICIONS) || i > 3 && this.matchPostagRegexp(tokens[i - 1], LOC_ADV) && this.matchPostagRegexp(tokens[i - 2], LOC_ADV) && !this.matchPostagRegexp(tokens[i - 3], VERB) && !this.matchPostagRegexp(tokens[i - 3], PREPOSICIONS))) {
            return null;
        }
        if (!isPlural || !this.matchPostagRegexp(tokens[i], ADJECTIU_S)) {
            this.initializeApparitions();
            for (j = 1; i - j > 0 && this.keepCounting(tokens[i - j]) && (level > 1 || j < 4); ++j) {
                if (!this.matchPostagRegexp(tokens[i - j], _GN_) && this.matchPostagRegexp(tokens[i - j], NOM_DET) && this.matchPostagRegexp(tokens[i - j], substPattern)) {
                    return null;
                }
                if (this.matchPostagRegexp(tokens[i - j], gnPattern)) {
                    return null;
                }
                j = this.updateJValue(tokens, i, j, 0);
                this.updateApparitions(tokens[i - j]);
            }
        }
        FrenchSynthesizer synth = FrenchSynthesizer.INSTANCE;
        List<Object> suggestions = new ArrayList<String>();
        AnalyzedToken at = this.getAnalyzedToken(tokens[patternTokenPos], ADJECTIU_CS);
        if (at != null) {
            suggestions.addAll(Arrays.asList(synth.synthesize(at, "J e p", true)));
        }
        if (suggestions.isEmpty() && (at = this.getAnalyzedToken(tokens[patternTokenPos], ADJECTIU_CP)) != null) {
            suggestions.addAll(Arrays.asList(synth.synthesize(at, "J e s", true)));
        }
        if (suggestions.isEmpty() && isPlural && (at = this.getAnalyzedToken(tokens[patternTokenPos], ADJECTIU_P)) != null) {
            suggestions.addAll(Arrays.asList(synth.synthesize(at, "J . p|V ppa . p", true)));
        }
        if ((at = this.getAnalyzedToken(tokens[patternTokenPos], ADJECTIU)) != null && suggestions.isEmpty()) {
            if (canBeMS && !isPlural) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [me] sp?|V ppa m s", true)));
            }
            if (canBeFS && !isPlural) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [fe] sp?|V ppa f s", true)));
            }
            if (canBeMP) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [me] s?p|V ppa m p", true)));
            }
            if (canBeFP) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [fe] s?p|V ppa f p", true)));
            }
            if (canBeMS && (isPlural || canBeP)) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [me] s?p|V ppa m p", true)));
            }
            if (canBeFS && !canBeMS && (isPlural || canBeP)) {
                suggestions.addAll(Arrays.asList(synth.synthesize(at, "J [fe] s?p|V ppa f p", true)));
            }
        }
        if ((suggestions = suggestions.stream().distinct().collect(Collectors.toList())).contains(tokens[patternTokenPos].getToken().toLowerCase())) {
            suggestions.remove(tokens[patternTokenPos].getToken().toLowerCase());
        }
        match.setSuggestedReplacements(suggestions);
        return match;
    }

    private int updateJValue(AnalyzedTokenReadings[] tokens, int i, int j, int level) {
        if (this.matchRegexp(tokens[i - j].getToken(), COORDINACIO_IONI) && i - j - 1 > 0 && i - j + 1 < tokens.length && this.matchPostagRegexp(tokens[i - j - 1], DET) && tokens[i - j + 1].getToken().equals("plus")) {
            ++j;
        }
        return j;
    }

    private boolean keepCounting(AnalyzedTokenReadings aTr) {
        if (this.matchRegexp(aTr.getToken(), PREPOSICIO_CANVI_NIVELL)) {
            return true;
        }
        if (aTr.getToken().equals(".")) {
            return true;
        }
        if (this.adverbAppeared && this.conjunctionAppeared || this.adverbAppeared && this.punctuationAppeared || this.conjunctionAppeared && this.punctuationAppeared || this.punctuationAppeared && this.matchPostagRegexp(aTr, PUNTUACIO) || this.infinitiveAppeared && this.matchRegexp(aTr.getToken(), COORDINACIO_IONI) || this.infinitiveAppeared && this.adverbAppeared) {
            return false;
        }
        return !(!this.matchPostagRegexp(aTr, KEEP_COUNT) && !this.matchRegexp(aTr.getToken(), KEEP_COUNT2) && !this.matchPostagRegexp(aTr, ADVERBIS_ACCEPTATS) || this.matchRegexp(aTr.getToken(), STOP_COUNT) || this.matchPostagRegexp(aTr, GV) && !this.matchPostagRegexp(aTr, _GN_));
    }

    private void initializeApparitions() {
        this.adverbAppeared = false;
        this.conjunctionAppeared = false;
        this.punctuationAppeared = false;
        this.infinitiveAppeared = false;
    }

    private void updateApparitions(AnalyzedTokenReadings aTr) {
        this.conjunctionAppeared |= this.matchPostagRegexp(aTr, CONJUNCIO);
        if (aTr.getToken().equals("com")) {
            return;
        }
        if (this.matchPostagRegexp(aTr, NOM) || this.matchPostagRegexp(aTr, ADJECTIU)) {
            this.initializeApparitions();
            return;
        }
        this.adverbAppeared |= this.matchPostagRegexp(aTr, ADVERBI);
        this.punctuationAppeared |= this.matchPostagRegexp(aTr, PUNTUACIO) || aTr.getToken().equals(",");
        this.infinitiveAppeared |= this.matchPostagRegexp(aTr, INFINITIVE);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private boolean matchRegexp(String s, Pattern pattern) {
        Matcher m = pattern.matcher(s);
        return m.matches();
    }

    private AnalyzedToken getAnalyzedToken(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return analyzedToken;
        }
        return null;
    }
}

