/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.French;
import org.languagetool.rules.AbstractFindSuggestionsFilter;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tools.StringTools;

public class FindSuggestionsFilter
extends AbstractFindSuggestionsFilter {
    private static final Pattern ENDS_IN_VOWEL = Pattern.compile("[aeiou\u00e9]$");
    private static final Pattern PATTERN = Pattern.compile("^[smntl]'|^(nous|vous|le|la|les|me|te|se|leur|en|y) ");
    private final SpellingCheckRule morfologikRule = French.getInstance().getDefaultSpellingRule();

    protected Tagger getTagger() {
        return FrenchTagger.INSTANCE;
    }

    protected Synthesizer getSynthesizer() {
        return FrenchSynthesizer.INSTANCE;
    }

    protected List<String> getSpellingSuggestions(AnalyzedTokenReadings atr) throws IOException {
        String w = atr.isTagged() ? StringTools.makeWrong((String)atr.getToken()) : atr.getToken();
        ArrayList<String> suggestions = new ArrayList<String>();
        ArrayList<Object> wordsToCheck = new ArrayList<Object>();
        wordsToCheck.add(w);
        if (w.endsWith("s")) {
            wordsToCheck.add(w.substring(0, w.length() - 1));
        }
        if (ENDS_IN_VOWEL.matcher(w).matches()) {
            wordsToCheck.add(w + "s");
        }
        for (String string : wordsToCheck) {
            AnalyzedTokenReadings[] atk = new AnalyzedTokenReadings[1];
            AnalyzedToken token = new AnalyzedToken(string, null, null);
            atk[0] = new AnalyzedTokenReadings(token);
            AnalyzedSentence sentence = new AnalyzedSentence(atk);
            RuleMatch[] matches = this.morfologikRule.match(sentence);
            if (matches.length <= 0) continue;
            suggestions.addAll(matches[0].getSuggestedReplacements());
        }
        return suggestions;
    }

    protected String cleanSuggestion(String s) {
        String output = PATTERN.matcher(s).replaceAll("");
        output = output.split(" ")[0];
        return output;
    }
}

