/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.French;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tools.StringTools;

public class InterrogativeVerbFilter
extends RuleFilter {
    private final SpellingCheckRule morfologikRule = French.getInstance().getDefaultSpellingRule();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        ArrayList<Object> replacements = new ArrayList<Object>();
        String pronounFrom = this.getRequired("PronounFrom", arguments);
        String verbFrom = this.getRequired("VerbFrom", arguments);
        String desiredPostag = null;
        ArrayList<Object> extraSuggestions = new ArrayList<Object>();
        if (pronounFrom != null && verbFrom != null) {
            int posPronoun = Integer.parseInt(pronounFrom);
            if (posPronoun < 1 || posPronoun > patternTokens.length) {
                throw new IllegalArgumentException("ConfusionCheckFilter: Index out of bounds in " + match.getRule().getFullId() + ", PronounFrom: " + posPronoun);
            }
            int posVerb = Integer.parseInt(verbFrom);
            if (posVerb < 1 || posVerb > patternTokens.length) {
                throw new IllegalArgumentException("ConfusionCheckFilter: Index out of bounds in " + match.getRule().getFullId() + ", VerbFrom: " + posVerb);
            }
            AnalyzedTokenReadings atrPronoun = patternTokens[posPronoun - 1];
            if (atrPronoun.matchesPosTagRegex("R pers obj 2 p")) {
                desiredPostag = "V.* (imp) [23] [sp]|V .*(ind|cond).* 2 p";
            } else if (atrPronoun.matchesPosTagRegex("R pers obj 1 p")) {
                desiredPostag = "V.* (imp) .*|V .*(ind|cond).* 1 p";
            } else if (atrPronoun.matchesPosTagRegex("R pers obj.*")) {
                desiredPostag = "V.* (imp) .*";
            } else if (atrPronoun.matchesPosTagRegex(".* 1 s")) {
                String[] participles;
                desiredPostag = "V .*(ind|cond).* 1 s";
                AnalyzedTokenReadings atrVerb = patternTokens[posVerb - 1];
                AnalyzedToken analyzedToken = atrVerb.readingWithTagRegex("V .*");
                if (analyzedToken != null && (participles = FrenchSynthesizer.INSTANCE.synthesize(analyzedToken, "V ppa [me] sp?", true)).length > 0 && participles[0].endsWith("\u00e9")) {
                    extraSuggestions.add(participles[0]);
                    extraSuggestions.add(participles[0].substring(0, participles[0].length() - 1) + "\u00e8");
                }
            } else if (atrPronoun.matchesPosTagRegex(".* 2 s")) {
                desiredPostag = "V .*(ind|cond).* 2 s";
            } else if (atrPronoun.matchesPosTagRegex(".* 3( [mfe])? s")) {
                desiredPostag = "V .*(ind|cond).* 3 s";
            } else if (atrPronoun.matchesPosTagRegex(".* 1 p")) {
                desiredPostag = "V .*(ind|cond).* 1 p";
            } else if (atrPronoun.matchesPosTagRegex(".* 2 p")) {
                desiredPostag = "V .*(ind|cond).* 2 p";
            } else if (atrPronoun.matchesPosTagRegex(".* 3( [mf])? p")) {
                desiredPostag = "V .*(ind|cond).* 3 p";
            }
            if (extraSuggestions.size() > 0) {
                for (String string : extraSuggestions) {
                    String separator;
                    String completeSuggestion = string + (separator = atrPronoun.getToken().startsWith("-") ? "" : "-") + atrPronoun.getToken();
                    if (replacements.contains(completeSuggestion) || completeSuggestion.endsWith("e-je")) continue;
                    replacements.add(completeSuggestion);
                }
            } else if (desiredPostag != null) {
                AnalyzedTokenReadings[] auxPatternTokens = new AnalyzedTokenReadings[]{patternTokens[posVerb - 1].isTagged() ? new AnalyzedTokenReadings(new AnalyzedToken(this.makeWrong(patternTokens[posVerb - 1].getToken()), null, null)) : patternTokens[posVerb - 1]};
                AnalyzedSentence analyzedSentence = new AnalyzedSentence(auxPatternTokens);
                RuleMatch[] matches = this.morfologikRule.match(analyzedSentence);
                if (matches.length > 0) {
                    List suggestions = matches[0].getSuggestedReplacements();
                    List<AnalyzedTokenReadings> analyzedSuggestions = FrenchTagger.INSTANCE.tag(suggestions);
                    for (AnalyzedTokenReadings analyzedSuggestion : analyzedSuggestions) {
                        if (!analyzedSuggestion.matchesPosTagRegex(desiredPostag)) continue;
                        String separator = atrPronoun.getToken().startsWith("-") ? "" : "-";
                        Object completeSuggestion = analyzedSuggestion.getToken() + separator + atrPronoun.getToken();
                        if (((String)completeSuggestion).equalsIgnoreCase("peux-je")) {
                            completeSuggestion = StringTools.preserveCase((String)"puis-je", (String)completeSuggestion);
                        }
                        if (((String)completeSuggestion).endsWith("e-je")) {
                            if (!replacements.contains(completeSuggestion = ((String)completeSuggestion).substring(0, ((String)completeSuggestion).length() - 4) + "\u00e9-je")) {
                                replacements.add(completeSuggestion);
                            }
                            if (replacements.contains(completeSuggestion = ((String)completeSuggestion).substring(0, ((String)completeSuggestion).length() - 4) + "\u00e8-je")) continue;
                            replacements.add(completeSuggestion);
                            continue;
                        }
                        if (replacements.contains(completeSuggestion)) continue;
                        replacements.add(completeSuggestion);
                    }
                }
            }
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        if (!replacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(replacements);
        }
        return ruleMatch;
    }

    private String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ed");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00fc");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00e0")) {
            return s.replace("\u00e0", "\u00e4");
        }
        if (s.contains("\u00e8")) {
            return s.replace("\u00e8", "\u00eb");
        }
        if (s.contains("\u00f9")) {
            return s.replace("\u00f9", "\u00fc");
        }
        if (s.contains("\u00e2")) {
            return s.replace("\u00e2", "\u00e4");
        }
        if (s.contains("\u00ea")) {
            return s.replace("\u00ea", "\u00eb");
        }
        if (s.contains("\u00ee")) {
            return s.replace("\u00ee", "\u00ef");
        }
        if (s.contains("\u00f4")) {
            return s.replace("\u00f4", "\u00f6");
        }
        if (s.contains("\u00fb")) {
            return s.replace("\u00fb", "\u00fc");
        }
        return s + "-";
    }
}

