/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ga;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.tagging.ga.Retaggable;

public class Utils {
    private static final List<SuffixGuess> guesses = Arrays.asList(new SuffixGuess("\u00e9aracht", "\u00e9ireacht", ".*Noun.*", ":MorphError"), new SuffixGuess("\u00e9arachta", "\u00e9ireachta", ".*Noun.*", ":MorphError"), new SuffixGuess("eamhail", "i\u00fail", ".*Noun.*|.*Adj.*", ":MorphError"), new SuffixGuess("eamhuil", "i\u00fail", ".*Noun.*|.*Adj.*", ":MorphError"), new SuffixGuess("eamhla", "i\u00fala", ".*Noun.*|.*Adj.*", ":MorphError"), new SuffixGuess("amhail", "\u00fail", ".*Noun.*|.*Adj.*", ":MorphError"), new SuffixGuess("amhuil", "\u00fail", ".*Noun.*|.*Adj.*", ":MorphError"));
    private static final int MATHEMATICAL_BOLD_CAPITAL_A = 56320;
    private static final int MATHEMATICAL_BOLD_CAPITAL_Z = 56345;
    private static final int MATHEMATICAL_BOLD_SMALL_A = 56346;
    private static final int MATHEMATICAL_BOLD_SMALL_Z = 56371;
    private static final int MATHEMATICAL_ITALIC_CAPITAL_A = 56372;
    private static final int MATHEMATICAL_ITALIC_CAPITAL_Z = 56397;
    private static final int MATHEMATICAL_ITALIC_SMALL_A = 56398;
    private static final int MATHEMATICAL_ITALIC_SMALL_Z = 56423;
    private static final int MATHEMATICAL_BOLD_ITALIC_CAPITAL_A = 56424;
    private static final int MATHEMATICAL_BOLD_ITALIC_CAPITAL_Z = 56449;
    private static final int MATHEMATICAL_BOLD_ITALIC_SMALL_A = 56450;
    private static final int MATHEMATICAL_BOLD_ITALIC_SMALL_Z = 56475;
    private static final int MATHEMATICAL_SCRIPT_CAPITAL_A = 56476;
    private static final int MATHEMATICAL_SCRIPT_CAPITAL_Z = 56501;
    private static final int MATHEMATICAL_SCRIPT_SMALL_A = 56502;
    private static final int MATHEMATICAL_SCRIPT_SMALL_Z = 56527;
    private static final int MATHEMATICAL_BOLD_SCRIPT_CAPITAL_A = 56528;
    private static final int MATHEMATICAL_BOLD_SCRIPT_CAPITAL_Z = 56553;
    private static final int MATHEMATICAL_BOLD_SCRIPT_SMALL_A = 56554;
    private static final int MATHEMATICAL_BOLD_SCRIPT_SMALL_Z = 56579;
    private static final int MATHEMATICAL_FRAKTUR_CAPITAL_A = 56580;
    private static final int MATHEMATICAL_FRAKTUR_CAPITAL_Z = 56605;
    private static final int MATHEMATICAL_FRAKTUR_SMALL_A = 56606;
    private static final int MATHEMATICAL_FRAKTUR_SMALL_Z = 56631;
    private static final int MATHEMATICAL_DOUBLESTRUCK_CAPITAL_A = 56632;
    private static final int MATHEMATICAL_DOUBLESTRUCK_CAPITAL_Z = 56657;
    private static final int MATHEMATICAL_DOUBLESTRUCK_SMALL_A = 56658;
    private static final int MATHEMATICAL_DOUBLESTRUCK_SMALL_Z = 56683;
    private static final int MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_A = 56684;
    private static final int MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_Z = 56709;
    private static final int MATHEMATICAL_BOLD_FRAKTUR_SMALL_A = 56710;
    private static final int MATHEMATICAL_BOLD_FRAKTUR_SMALL_Z = 56735;
    private static final int MATHEMATICAL_SANSSERIF_CAPITAL_A = 56736;
    private static final int MATHEMATICAL_SANSSERIF_CAPITAL_Z = 56761;
    private static final int MATHEMATICAL_SANSSERIF_SMALL_A = 56762;
    private static final int MATHEMATICAL_SANSSERIF_SMALL_Z = 56787;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_CAPITAL_A = 56788;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_CAPITAL_Z = 56813;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_SMALL_A = 56814;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_SMALL_Z = 56839;
    private static final int MATHEMATICAL_SANSSERIF_ITALIC_CAPITAL_A = 56840;
    private static final int MATHEMATICAL_SANSSERIF_ITALIC_CAPITAL_Z = 56865;
    private static final int MATHEMATICAL_SANSSERIF_ITALIC_SMALL_A = 56866;
    private static final int MATHEMATICAL_SANSSERIF_ITALIC_SMALL_Z = 56891;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_CAPITAL_A = 56892;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_CAPITAL_Z = 56917;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_SMALL_A = 56918;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_SMALL_Z = 56943;
    private static final int MATHEMATICAL_MONOSPACE_CAPITAL_A = 56944;
    private static final int MATHEMATICAL_MONOSPACE_CAPITAL_Z = 56969;
    private static final int MATHEMATICAL_MONOSPACE_SMALL_A = 56970;
    private static final int MATHEMATICAL_MONOSPACE_SMALL_Z = 56995;
    private static final int MATHEMATICAL_ITALIC_SMALL_DOTLESS_I = 56996;
    private static final int MATHEMATICAL_ITALIC_SMALL_DOTLESS_J = 56997;
    private static final int MATHEMATICAL_BOLD_CAPITAL_ALPHA = 57000;
    private static final int MATHEMATICAL_BOLD_CAPITAL_OMEGA = 57024;
    private static final int MATHEMATICAL_BOLD_SMALL_ALPHA = 57026;
    private static final int MATHEMATICAL_BOLD_SMALL_OMEGA = 57050;
    private static final int MATHEMATICAL_ITALIC_CAPITAL_ALPHA = 57058;
    private static final int MATHEMATICAL_ITALIC_CAPITAL_OMEGA = 57082;
    private static final int MATHEMATICAL_ITALIC_SMALL_ALPHA = 57084;
    private static final int MATHEMATICAL_ITALIC_SMALL_OMEGA = 57108;
    private static final int MATHEMATICAL_BOLD_ITALIC_CAPITAL_ALPHA = 57116;
    private static final int MATHEMATICAL_BOLD_ITALIC_CAPITAL_OMEGA = 57140;
    private static final int MATHEMATICAL_BOLD_ITALIC_SMALL_ALPHA = 57142;
    private static final int MATHEMATICAL_BOLD_ITALIC_SMALL_OMEGA = 57166;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_CAPITAL_ALPHA = 57174;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_CAPITAL_OMEGA = 57198;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_SMALL_ALPHA = 57200;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_SMALL_OMEGA = 57224;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_CAPITAL_ALPHA = 57232;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_CAPITAL_OMEGA = 57256;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_SMALL_ALPHA = 57258;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_ITALIC_SMALL_OMEGA = 57282;
    private static final int MATHEMATICAL_BOLD_DIGIT_ZERO = 57294;
    private static final int MATHEMATICAL_BOLD_DIGIT_NINE = 57303;
    private static final int MATHEMATICAL_DOUBLESTRUCK_DIGIT_ZERO = 57304;
    private static final int MATHEMATICAL_DOUBLESTRUCK_DIGIT_NINE = 57313;
    private static final int MATHEMATICAL_SANSSERIF_DIGIT_ZERO = 57314;
    private static final int MATHEMATICAL_SANSSERIF_DIGIT_NINE = 57323;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_DIGIT_ZERO = 57324;
    private static final int MATHEMATICAL_SANSSERIF_BOLD_DIGIT_NINE = 57333;
    private static final int MATHEMATICAL_MONOSPACE_DIGIT_ZERO = 57334;
    private static final int MATHEMATICAL_MONOSPACE_DIGIT_NINE = 57343;
    private static final int CAPITAL_A = 65;
    private static final int SMALL_A = 97;
    private static final int CAPITAL_ALPHA = 913;
    private static final int SMALL_ALPHA = 945;
    private static final int DIGIT_ZERO = 48;

    public static Retaggable fixSuffix(String in) {
        for (SuffixGuess guess : guesses) {
            if (!in.endsWith(guess.suffix)) continue;
            String base = in.substring(0, in.length() - guess.suffix.length());
            return new Retaggable(base + guess.suffixReplacement, guess.restrictToTags, guess.appendTags);
        }
        return new Retaggable(in, "", "");
    }

    public static List<Retaggable> morphWord(String in) {
        ArrayList<Retaggable> out = new ArrayList<Retaggable>();
        Retaggable mut = Utils.demutate(in);
        if (mut.getAppendTag().equals(":Len:MorphError") || mut.getAppendTag().equals(":Ecl:MorphError") || mut.getAppendTag().equals(":EclLen")) {
            out.add(mut);
            out.add(new Retaggable(mut.getWord(), mut.getRestrictToPos(), ":DefArt:MorphError"));
        } else if (!"".equals(mut.getAppendTag())) {
            out.add(mut);
        }
        Retaggable sfx = Utils.fixSuffix(mut.getWord());
        if (!"".equals(sfx.getAppendTag())) {
            sfx.setAppendTag(mut.getAppendTag());
            out.add(sfx);
        }
        return out;
    }

    public static Retaggable demutate(String in) {
        String out = Utils.unLeniteDefiniteS(in);
        if (out != null) {
            return new Retaggable(out, "(?:C[UMC]:)?Noun:.*:DefArt", ":MorphError");
        }
        out = Utils.unLenite(in);
        if (out != null) {
            return new Retaggable(out, "", ":Len:MorphError");
        }
        out = Utils.unEclipse(in);
        if (out != null) {
            String out2 = Utils.unLenite(out);
            if (out2 == null) {
                return new Retaggable(out, "", ":Ecl:MorphError");
            }
            return new Retaggable(out2, "", ":EclLen");
        }
        return new Retaggable(in, "", "");
    }

    public static String unEclipse(String in) {
        if (in.length() > 2) {
            char ch1 = in.charAt(1);
            switch (in.charAt(0)) {
                case 'N': 
                case 'n': {
                    if (in.length() > 3 && in.charAt(1) == '-') {
                        ch1 = in.charAt(2);
                    }
                    if (ch1 == 'G' || ch1 == 'D' || Utils.isUpperVowel(ch1) || ch1 == 'g' || ch1 == 'd' || Utils.isLowerVowel(ch1)) {
                        return Utils.unEclipseChar(in, 'n', Character.toLowerCase(ch1));
                    }
                    return null;
                }
                case 'B': 
                case 'b': {
                    if (ch1 == 'p' || ch1 == 'P' || in.length() > 3 && in.charAt(1) == '-') {
                        return Utils.unEclipseChar(in, 'b', 'p');
                    }
                    return Utils.unEclipseF(in);
                }
                case 'D': 
                case 'd': {
                    return Utils.unEclipseChar(in, 'd', 't');
                }
                case 'G': 
                case 'g': {
                    return Utils.unEclipseChar(in, 'g', 'c');
                }
                case 'M': 
                case 'm': {
                    return Utils.unEclipseChar(in, 'm', 'b');
                }
            }
        }
        return null;
    }

    public static String unLenite(String in) {
        if (in.length() < 2) {
            return null;
        }
        if (in.charAt(1) == 'h' || in.charAt(1) == 'H') {
            return in.charAt(0) + in.substring(2);
        }
        return null;
    }

    public static String unLeniteDefiniteS(String in) {
        String[] uppers = new String[]{"Ts", "T-s", "TS", "T-S", "t-S", "tS"};
        String[] lowers = new String[]{"ts", "t-s"};
        for (String start : uppers) {
            if (in.length() < start.length() || !in.startsWith(start)) continue;
            return "S" + in.substring(start.length());
        }
        for (String start : lowers) {
            if (in.length() < start.length() || !in.startsWith(start)) continue;
            return "s" + in.substring(start.length());
        }
        return null;
    }

    public static String unEclipseF(String in) {
        String[] uppers = new String[]{"Bhf", "bhF", "Bf", "bhF", "bF", "Bh-f", "bh-F", "B-f", "bh-F", "b-F"};
        String[] lowers = new String[]{"bhf", "bh-f", "bf", "b-f"};
        for (String start : uppers) {
            if (in.length() < start.length() || !in.startsWith(start)) continue;
            return "F" + in.substring(start.length());
        }
        for (String start : lowers) {
            if (in.length() < start.length() || !in.startsWith(start)) continue;
            return "f" + in.substring(start.length());
        }
        return null;
    }

    public static String unEclipseChar(String in, char first, char second) {
        char retSecond;
        int from = 2;
        char upperFirst = Character.toUpperCase(first);
        char upperSecond = Character.toUpperCase(second);
        char c = retSecond = in.charAt(0) == upperFirst ? upperSecond : second;
        if (in.length() < 2) {
            return null;
        }
        if (in.charAt(0) != first && in.charAt(0) != upperFirst) {
            return null;
        }
        if (in.charAt(0) == first && (in.charAt(1) == second || in.charAt(1) == upperSecond)) {
            return in.substring(1);
        }
        char ch1 = in.charAt(1);
        if (in.length() > 3 && in.charAt(1) == '-') {
            ++from;
            ch1 = in.charAt(2);
        }
        if (ch1 == second || ch1 == upperSecond) {
            return Character.toString(retSecond) + in.substring(from);
        }
        return null;
    }

    public static boolean isUpperVowel(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case '\u00c1': 
            case '\u00c9': 
            case '\u00cd': 
            case '\u00d3': 
            case '\u00da': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLowerVowel(char c) {
        switch (c) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': 
            case '\u00e1': 
            case '\u00e9': 
            case '\u00ed': 
            case '\u00f3': 
            case '\u00fa': {
                return true;
            }
        }
        return false;
    }

    public static boolean isVowel(char c) {
        return Utils.isLowerVowel(c) || Utils.isUpperVowel(c);
    }

    public static boolean isUpperLenitable(char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'G': 
            case 'M': 
            case 'P': 
            case 'S': 
            case 'T': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLowerLenitable(char c) {
        switch (c) {
            case 'b': 
            case 'c': 
            case 'd': 
            case 'f': 
            case 'g': 
            case 'm': 
            case 'p': 
            case 's': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSLenitable(char c) {
        switch (c) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'l': 
            case 'n': 
            case 'o': 
            case 'r': 
            case 'u': 
            case '\u00e1': 
            case '\u00e9': 
            case '\u00ed': 
            case '\u00f3': 
            case '\u00fa': {
                return true;
            }
        }
        return false;
    }

    public static String lenite(String in) {
        String outh;
        if (in.length() < 2) {
            return in;
        }
        String string = outh = Character.isUpperCase(in.charAt(0)) && Character.isUpperCase(1) ? "H" : "h";
        if (Utils.isLowerLenitable(in.charAt(0)) || Utils.isUpperLenitable(in.charAt(0))) {
            if (in.charAt(0) == 'S' || in.charAt(0) == 's') {
                if (Utils.isSLenitable(Character.toLowerCase(in.charAt(1)))) {
                    return Character.toString(in.charAt(0)) + outh + in.substring(1);
                }
                return in;
            }
            return Character.toString(in.charAt(0)) + outh + in.substring(1);
        }
        return in;
    }

    public static String eclipse(String in) {
        if (in == null || in.equals("")) {
            return in;
        }
        if (Utils.isUpperVowel(in.charAt(0))) {
            return "n" + in;
        }
        if (Utils.isLowerVowel(in.charAt(0))) {
            return "n-" + in;
        }
        switch (in.toLowerCase().charAt(0)) {
            case 'b': {
                return "m" + in;
            }
            case 'c': {
                return "g" + in;
            }
            case 'd': 
            case 'g': {
                return "n" + in;
            }
            case 'f': {
                return "bh" + in;
            }
            case 'p': {
                return "b" + in;
            }
            case 't': {
                return "d" + in;
            }
        }
        return in;
    }

    public static String toLowerCaseIrish(String s) {
        if (s.length() > 1 && (s.charAt(0) == 'n' || s.charAt(0) == 't') && Utils.isUpperVowel(s.charAt(1))) {
            return s.substring(0, 1) + "-" + s.substring(1).toLowerCase();
        }
        return s.toLowerCase();
    }

    public static boolean startsWithUppercase(String s) {
        if (Utils.startsWithMutatedUppercase(s)) {
            return true;
        }
        return Character.isUpperCase(s.charAt(0));
    }

    public static boolean isAllUppercase(String s) {
        int startFrom = 0;
        if (Utils.startsWithMutatedUppercase(s)) {
            startFrom = s.startsWith("bhF") ? 2 : 1;
        }
        for (char c : s.substring(startFrom).toCharArray()) {
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithMutatedUppercase(String s) {
        if (s.startsWith("mB")) {
            return true;
        }
        if (s.startsWith("gC")) {
            return true;
        }
        if (s.startsWith("nD")) {
            return true;
        }
        if (s.startsWith("bhF")) {
            return true;
        }
        if (s.startsWith("nG")) {
            return true;
        }
        if (s.startsWith("bP")) {
            return true;
        }
        if (s.startsWith("dT")) {
            return true;
        }
        if (s.length() > 1 && s.charAt(0) == 'n' && Utils.isUpperVowel(s.charAt(1))) {
            return true;
        }
        if (s.length() > 1 && s.charAt(0) == 't' && Utils.isUpperVowel(s.charAt(1))) {
            return true;
        }
        if (s.length() > 1 && s.charAt(0) == 'h' && Utils.isUpperVowel(s.charAt(1))) {
            return true;
        }
        return s.startsWith("tS");
    }

    private static boolean isUpperPonc(char c) {
        switch (c) {
            case '\u010a': 
            case '\u0120': 
            case '\u1e02': 
            case '\u1e0a': 
            case '\u1e1e': 
            case '\u1e40': 
            case '\u1e56': 
            case '\u1e60': 
            case '\u1e6a': {
                return true;
            }
        }
        return false;
    }

    private static boolean isLowerPonc(char c) {
        switch (c) {
            case '\u010b': 
            case '\u0121': 
            case '\u1e03': 
            case '\u1e0b': 
            case '\u1e1f': 
            case '\u1e41': 
            case '\u1e57': 
            case '\u1e61': 
            case '\u1e6b': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPonc(char c) {
        return Utils.isUpperPonc(c) || Utils.isLowerPonc(c);
    }

    public static boolean containsPonc(String s) {
        for (char c : s.toCharArray()) {
            if (!Utils.isPonc(c)) continue;
            return true;
        }
        return false;
    }

    private static char unPonc(char c) {
        switch (c) {
            case '\u1e02': {
                return 'B';
            }
            case '\u010a': {
                return 'C';
            }
            case '\u1e0a': {
                return 'D';
            }
            case '\u1e1e': {
                return 'F';
            }
            case '\u0120': {
                return 'G';
            }
            case '\u1e40': {
                return 'M';
            }
            case '\u1e56': {
                return 'P';
            }
            case '\u1e60': {
                return 'S';
            }
            case '\u1e6a': {
                return 'T';
            }
            case '\u1e03': {
                return 'b';
            }
            case '\u010b': {
                return 'c';
            }
            case '\u1e0b': {
                return 'd';
            }
            case '\u1e1f': {
                return 'f';
            }
            case '\u0121': {
                return 'g';
            }
            case '\u1e41': {
                return 'm';
            }
            case '\u1e57': {
                return 'p';
            }
            case '\u1e61': {
                return 's';
            }
            case '\u1e6b': {
                return 't';
            }
        }
        return c;
    }

    public static String unPonc(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Utils.isPonc(s.charAt(i))) {
                sb.append(Utils.unPonc(s.charAt(i)));
                continue;
            }
            if (Utils.isLowerPonc(s.charAt(i))) {
                sb.append(Utils.unPonc(s.charAt(i)));
                sb.append('h');
                continue;
            }
            if (i < s.length() - 1 && Character.isUpperCase(s.charAt(i + 1))) {
                sb.append(Utils.unPonc(s.charAt(i)));
                sb.append('H');
                continue;
            }
            if (i == s.length() - 1 && i > 0 && Character.isUpperCase(s.charAt(i - 1))) {
                sb.append(Utils.unPonc(s.charAt(i)));
                sb.append('H');
                continue;
            }
            sb.append(Utils.unPonc(s.charAt(i)));
            sb.append('h');
        }
        return sb.toString();
    }

    public static boolean isAllMathsChars(String s) {
        if (s.length() % 2 != 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char numValue;
            if (!(i % 2 == 0 ? s.charAt(i) != '\ud835' : (numValue = s.charAt(i)) < '\udc00' || numValue > '\udfff')) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllHalfWidthChars(String s) {
        for (char c : s.toCharArray()) {
            char charValue = c;
            if (charValue < '\uff21') {
                return false;
            }
            if (charValue > '\uff3a' && charValue < '\uff41') {
                return false;
            }
            if (charValue <= '\uff5a') continue;
            return false;
        }
        return true;
    }

    public static String halfwidthLatinToLatin(String s) {
        StringBuilder sb = new StringBuilder();
        char HALFWIDTH_LATIN_CAPITAL_A = '\uff21';
        char HALFWIDTH_LATIN_CAPITAL_Z = '\uff3a';
        char HALFWIDTH_LATIN_SMALL_A = '\uff41';
        char HALFWIDTH_LATIN_SMALL_Z = '\uff5a';
        for (char c : s.toCharArray()) {
            char charValue = c;
            if (charValue >= HALFWIDTH_LATIN_CAPITAL_A && charValue <= HALFWIDTH_LATIN_CAPITAL_Z) {
                sb.append((char)(charValue - HALFWIDTH_LATIN_CAPITAL_A + 65));
                continue;
            }
            if (charValue >= HALFWIDTH_LATIN_SMALL_A && charValue <= HALFWIDTH_LATIN_SMALL_Z) {
                sb.append((char)(charValue - HALFWIDTH_LATIN_SMALL_A + 97));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char getMathsChar(char c) {
        return Utils.getMathsChar(c, false, false);
    }

    private static char getMathsChar(char c, boolean normaliseGreek, boolean normaliseDigits) {
        char numeric = c;
        if (numeric < '\u0000') {
            throw new RuntimeException("Failed to read character " + c);
        }
        if (numeric < '\udc00') {
            return c;
        }
        if (numeric <= '\udc19') {
            return (char)(numeric - 56320 + 65);
        }
        if (numeric <= '\udc33') {
            return (char)(numeric - 56346 + 97);
        }
        if (numeric <= '\udc4d') {
            return (char)(numeric - 56372 + 65);
        }
        if (numeric <= '\udc67') {
            return (char)(numeric - 56398 + 97);
        }
        if (numeric <= '\udc81') {
            return (char)(numeric - 56424 + 65);
        }
        if (numeric <= '\udc9b') {
            return (char)(numeric - 56450 + 97);
        }
        if (numeric <= '\udcb5') {
            return (char)(numeric - 56476 + 65);
        }
        if (numeric <= '\udccf') {
            return (char)(numeric - 56502 + 97);
        }
        if (numeric <= '\udce9') {
            return (char)(numeric - 56528 + 65);
        }
        if (numeric <= '\udd03') {
            return (char)(numeric - 56554 + 97);
        }
        if (numeric <= '\udd1d') {
            return (char)(numeric - 56580 + 65);
        }
        if (numeric <= '\udd37') {
            return (char)(numeric - 56606 + 97);
        }
        if (numeric <= '\udd51') {
            return (char)(numeric - 56632 + 65);
        }
        if (numeric <= '\udd6b') {
            return (char)(numeric - 56658 + 97);
        }
        if (numeric <= '\udd85') {
            return (char)(numeric - 56684 + 65);
        }
        if (numeric <= '\udd9f') {
            return (char)(numeric - 56710 + 97);
        }
        if (numeric <= '\uddb9') {
            return (char)(numeric - 56736 + 65);
        }
        if (numeric <= '\uddd3') {
            return (char)(numeric - 56762 + 97);
        }
        if (numeric <= '\udded') {
            return (char)(numeric - 56788 + 65);
        }
        if (numeric <= '\ude07') {
            return (char)(numeric - 56814 + 97);
        }
        if (numeric <= '\ude21') {
            return (char)(numeric - 56840 + 65);
        }
        if (numeric <= '\ude3b') {
            return (char)(numeric - 56866 + 97);
        }
        if (numeric <= '\ude55') {
            return (char)(numeric - 56892 + 65);
        }
        if (numeric <= '\ude6f') {
            return (char)(numeric - 56918 + 97);
        }
        if (numeric <= '\ude89') {
            return (char)(numeric - 56944 + 65);
        }
        if (numeric <= '\udea3') {
            return (char)(numeric - 56970 + 97);
        }
        if (numeric == '\udea4') {
            return 'i';
        }
        if (numeric == '\udea5') {
            return 'j';
        }
        if (normaliseGreek) {
            if (numeric >= '\udea8' && numeric <= '\udec0') {
                return (char)(numeric - 57000 + 913);
            }
            if (numeric >= '\udec2' && numeric <= '\udeda') {
                return (char)(numeric - 57026 + 945);
            }
            if (numeric >= '\udee2' && numeric <= '\udefa') {
                return (char)(numeric - 57058 + 913);
            }
            if (numeric >= '\udefc' && numeric <= '\udf14') {
                return (char)(numeric - 57084 + 945);
            }
            if (numeric >= '\udf1c' && numeric <= '\udf34') {
                return (char)(numeric - 57116 + 913);
            }
            if (numeric >= '\udf36' && numeric <= '\udf4e') {
                return (char)(numeric - 57142 + 945);
            }
            if (numeric >= '\udf56' && numeric <= '\udf6e') {
                return (char)(numeric - 57174 + 913);
            }
            if (numeric >= '\udf70' && numeric <= '\udf88') {
                return (char)(numeric - 57200 + 945);
            }
            if (numeric >= '\udf90' && numeric <= '\udfa8') {
                return (char)(numeric - 57232 + 913);
            }
            if (numeric >= '\udfaa' && numeric <= '\udfc2') {
                return (char)(numeric - 57258 + 945);
            }
        } else if (normaliseDigits) {
            if (numeric >= '\udfce' && numeric <= '\udfd7') {
                return (char)(numeric - 57294 + 48);
            }
            if (numeric <= '\udfe1') {
                return (char)(numeric - 57304 + 48);
            }
            if (numeric <= '\udfeb') {
                return (char)(numeric - 57314 + 48);
            }
            if (numeric <= '\udff5') {
                return (char)(numeric - 57324 + 48);
            }
            if (numeric <= '\udfff') {
                return (char)(numeric - 57334 + 48);
            }
        }
        return c;
    }

    public static String simplifyMathematical(String s) {
        return Utils.simplifyMathematical(s, false, false);
    }

    public static String simplifyMathematical(String s, boolean normaliseGreek, boolean normaliseDigits) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int j;
            if (s.charAt(i) != '\ud835' || (j = i + 1) >= s.length() || s.charAt(j) < '\udc00' || s.charAt(j) > '\udfff') continue;
            char mapped = Utils.getMathsChar(s.charAt(j), normaliseGreek, normaliseDigits);
            if (mapped == s.charAt(j)) {
                out.append(s.charAt(i));
                out.append(s.charAt(j));
                continue;
            }
            out.append(mapped);
        }
        return out.toString();
    }

    private static char greekLookalikes(char c) {
        switch (c) {
            case '\u0391': {
                return 'A';
            }
            case '\u0392': {
                return 'B';
            }
            case '\u0395': {
                return 'E';
            }
            case '\u0396': {
                return 'Z';
            }
            case '\u0397': {
                return 'H';
            }
            case '\u0399': {
                return 'I';
            }
            case '\u039a': {
                return 'K';
            }
            case '\u039c': {
                return 'M';
            }
            case '\u039d': {
                return 'N';
            }
            case '\u039f': {
                return 'O';
            }
            case '\u03a1': {
                return 'P';
            }
            case '\u03a4': {
                return 'T';
            }
            case '\u03a5': {
                return 'Y';
            }
            case '\u03a7': {
                return 'X';
            }
            case '\u03b1': {
                return 'a';
            }
            case '\u03b2': {
                return 'B';
            }
            case '\u03b3': {
                return 'y';
            }
            case '\u03b4': {
                return 'd';
            }
            case '\u03b5': {
                return 'e';
            }
            case '\u03b7': {
                return 'n';
            }
            case '\u03b9': {
                return 'i';
            }
            case '\u03ba': {
                return 'K';
            }
            case '\u03bd': {
                return 'v';
            }
            case '\u03bf': {
                return 'o';
            }
            case '\u03c1': {
                return 'p';
            }
            case '\u03c4': {
                return 'T';
            }
            case '\u03c7': {
                return 'x';
            }
            case '\u03c9': {
                return 'w';
            }
        }
        return c;
    }

    public static String greekToLatin(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            sb.append(Utils.greekLookalikes(c));
        }
        return sb.toString();
    }

    public static boolean hasMixedGreekAndLatin(String s) {
        return s.matches(".*[A-Za-z].*") && s.matches(".*\\p{InGREEK}.*");
    }

    public static boolean hasMixedGreekAndCyrillic(String s) {
        return s.matches(".*[A-Za-z].*") && s.matches(".*\\p{InCYRILLIC}.*");
    }

    private static class SuffixGuess {
        public String suffix;
        public String suffixReplacement;
        public String restrictToTags;
        public String appendTags;

        SuffixGuess(String suffix, String suffixReplacement, String restrictToTags, String appendTags) {
            this.suffix = suffix;
            this.suffixReplacement = suffixReplacement;
            this.restrictToTags = restrictToTags;
            this.appendTags = appendTags;
        }
    }
}

