/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tagging.ga.Utils;

public class IrishSpecificCaseRule
extends Rule {
    private static final Set<String> phrases = new HashSet<String>(IrishSpecificCaseRule.loadPhrases("/ga/specific_case.txt"));
    private static int maxLen;
    private static final Map<String, String> lcToProperSpelling;

    private static List<String> loadPhrases(String path) {
        ArrayList<String> l = new ArrayList<String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            int parts = line.split(" ").length;
            maxLen = Math.max(parts, maxLen);
            l.add(line.trim());
        }
        return l;
    }

    public IrishSpecificCaseRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Rugadh agus t\u00f3gadh i <marker>mb\u00e9al Feirste</marker> \u00e9."), Example.fixed((String)"Rugadh agus t\u00f3gadh i <marker>mB\u00e9al Feirste</marker> \u00e9."));
    }

    public final String getId() {
        return "GA_SPECIFIC_CASE";
    }

    public String getDescription() {
        return "Checks upper/lower case spelling of some proper nouns";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList<String> l = new ArrayList<String>();
            int j = 0;
            while (l.size() < maxLen && i + j < tokens.length) {
                l.add(tokens[i + j].getToken());
                ++j;
                String phrase = String.join((CharSequence)" ", l);
                String lcPhrase = phrase.toLowerCase();
                String properSpelling = lcToProperSpelling.get(lcPhrase);
                if (properSpelling == null || Utils.isAllUppercase(phrase) || phrase.equals(properSpelling) || i > 0 && tokens[i - 1].isSentenceStart() && !Utils.startsWithUppercase(properSpelling)) continue;
                String msg = this.allWordsUppercase(properSpelling) ? "M\u00e1s ainmfhocal d\u00edlis \u00e9, scr\u00edobh \u00e9 i gceannlitreacha." : "If the term is a proper noun, use the suggested capitalization.";
                RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[i].getStartPos(), tokens[i].getStartPos() + phrase.length(), msg);
                match.setSuggestedReplacement(properSpelling);
                matches.add(match);
            }
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean allWordsUppercase(String s) {
        return Arrays.stream(s.split(" ")).allMatch(Utils::startsWithUppercase);
    }

    static {
        lcToProperSpelling = new HashMap<String, String>();
        for (String phrase : phrases) {
            lcToProperSpelling.put(phrase.toLowerCase(), phrase);
        }
    }
}

