/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PeopleRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = PeopleRule.loadFromPath((String)"/ga/names.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PeopleRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Bh\u00ed s\u00ed cos\u00fail le cla\u00edomh <marker>Damocles</marker> ar crochadh sa sp\u00e9ir."), Example.fixed((String)"Bh\u00ed s\u00ed cos\u00fail le cla\u00edomh <marker>D\u00e1maicl\u00e9as</marker> ar crochadh sa sp\u00e9ir."));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_PEOPLE";
    }

    public String getDescription() {
        return "Ainm B\u00e9arla, m.sh., 'Damocles' in \u00e1it 'D\u00e1maicl\u00e9as'.";
    }

    public String getShort() {
        return "Ainm B\u00e9arla";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Ainm B\u00e9arla. \"" + String.join((CharSequence)", ", replacements) + "\".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

