/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.km;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.km.KhmerRule;

public class KhmerSpaceBeforeRule
extends KhmerRule {
    private static final Pattern CONJUNCTIONS = Pattern.compile("\u178a\u17be\u1798\u17d2\u1794\u17b8|\u1793\u17b7\u1784|\u1796\u17b8\u1796\u17d2\u179a\u17c4\u17c7", 66);

    public KhmerSpaceBeforeRule(ResourceBundle messages, Language language) {
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    public String getId() {
        return "KM_SPACE_BEFORE_CONJUNCTION";
    }

    public String getDescription() {
        return "Checks for missing space before some conjunctions";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            Matcher matcher = CONJUNCTIONS.matcher(token);
            if (!matcher.matches() || tokens[i - 1].getToken().equals(" ")) continue;
            String replacement = " " + token;
            String msg = this.getSuggestion();
            int pos = tokens[i].getStartPos();
            RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + token.length(), msg, this.getShort());
            potentialRuleMatch.setSuggestedReplacement(replacement);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private String getShort() {
        return "Missing white space";
    }

    private String getSuggestion() {
        return "Missing white space before conjunction";
    }

    public void reset() {
    }
}

