/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.km;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.km.KhmerRule;
import org.languagetool.tools.StringTools;

public abstract class KhmerWordCoherencyRule
extends KhmerRule {
    private static final String FILE_NAME = "/km/coherency.txt";
    private static final String FILE_ENCODING = "utf-8";
    private final Map<String, String> wrongWords;

    public KhmerWordCoherencyRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(FILE_NAME));
    }

    public String getId() {
        return "KM_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Checks for wrong words/phrases";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String replacement;
            String token;
            String origToken = token = tokens[i].getToken();
            String string = replacement = this.isCaseSensitive() ? this.wrongWords.get(token) : this.wrongWords.get(token.toLowerCase(this.getLocale()));
            if (replacement == null) continue;
            String msg = token + this.getSuggestion() + replacement;
            int pos = tokens[i].getStartPos();
            RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + origToken.length(), msg, this.getShort());
            if (!this.isCaseSensitive() && StringTools.startsWithUppercase((String)token)) {
                potentialRuleMatch.setSuggestedReplacement(StringTools.uppercaseFirstChar((String)replacement));
            } else {
                potentialRuleMatch.setSuggestedReplacement(replacement);
            }
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isCaseSensitive() {
        return false;
    }

    private Locale getLocale() {
        return Locale.getDefault();
    }

    private String getShort() {
        return "Wrong word";
    }

    private String getSuggestion() {
        return " is not valid, use ";
    }

    private Map<String, String> loadWords(InputStream stream) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(stream, FILE_ENCODING);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length < 2) {
                    throw new IOException("Format error in file - Make sure you have removed the Unicode BOM as well as check for other errors: " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(FILE_NAME) + ", line: " + line);
                }
                for (int i = 0; i < parts.length - 1; ++i) {
                    map.put(parts[i], parts[parts.length - 1]);
                }
            }
        }
        return map;
    }

    public void reset() {
    }
}

