/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.km;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class KhmerWordRepeatRule
extends Rule {
    public KhmerWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    public boolean ignore(AnalyzedSentence sentence, AnalyzedTokenReadings[] tokensWithWhiteSpace, int position) {
        int origPos = sentence.getOriginalPosition(position);
        return position >= 1 && " ".equals(tokensWithWhiteSpace[origPos - 1].getToken());
    }

    public String getId() {
        return "KM_WORD_REPEAT_RULE";
    }

    public String getDescription() {
        return this.messages.getString("desc_repetition");
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] tokensWithWS = sentence.getTokens();
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            if (this.isWord(token) && prevToken.equalsIgnoreCase(token) && !this.ignore(sentence, tokensWithWS, i)) {
                int prevPos = tokens[i - 1].getStartPos();
                int pos = tokens[i].getStartPos();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, prevPos, pos + prevToken.length(), this.messages.getString("repetition"), this.messages.getString("desc_repetition_short"));
                ArrayList<String> replacements = new ArrayList<String>();
                replacements.add(prevToken + " " + token);
                replacements.add(prevToken);
                replacements.add(prevToken + "\u17d7");
                ruleMatch.setSuggestedReplacements(replacements);
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isWord(String token) {
        char c;
        return token.length() != 1 || Character.isLetter(c = token.charAt(0));
    }

    public void reset() {
    }
}

