/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.nl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class DutchWordTokenizer
extends WordTokenizer {
    private static final List<String> QUOTES = Arrays.asList("'", "`", "\u2019", "\u2018", "\u00b4");
    private final String nlTokenizingChars;

    public DutchWordTokenizer() {
        String chars = super.getTokenizingCharacters() + "_";
        for (String quote : QUOTES) {
            chars = chars.replace(quote, "");
        }
        this.nlTokenizingChars = chars;
    }

    public List<String> tokenize(String text) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, this.nlTokenizingChars, true);
        while (st.hasMoreElements()) {
            String token;
            String origToken = token = st.nextToken();
            if (token.length() > 1) {
                if (this.startsWithQuote(token) && this.endsWithQuote(token) && token.length() > 2) {
                    l.add(token.substring(0, 1));
                    l.add(token.substring(1, token.length() - 1));
                    l.add(token.substring(token.length() - 1));
                    continue;
                }
                if (this.endsWithQuote(token)) {
                    int cnt = 0;
                    while (this.endsWithQuote(token)) {
                        token = token.substring(0, token.length() - 1);
                        ++cnt;
                    }
                    l.add(token);
                    for (int i = origToken.length() - cnt; i < origToken.length(); ++i) {
                        l.add(origToken.substring(i, i + 1));
                    }
                    continue;
                }
                if (this.startsWithQuote(token)) {
                    while (this.startsWithQuote(token)) {
                        l.add(token.substring(0, 1));
                        token = token.substring(1);
                    }
                    l.add(token);
                    continue;
                }
                l.add(token);
                continue;
            }
            l.add(token);
        }
        return this.joinEMailsAndUrls(l);
    }

    private boolean startsWithQuote(String token) {
        for (String quote : QUOTES) {
            if (!token.startsWith(quote)) continue;
            return true;
        }
        return false;
    }

    private boolean endsWithQuote(String token) {
        for (String quote : QUOTES) {
            if (!token.endsWith(quote)) continue;
            return true;
        }
        return false;
    }

    public String getTokenizingCharacters() {
        return this.nlTokenizingChars;
    }
}

