/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.nl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Dutch;
import org.languagetool.rules.nl.CompoundAcceptor;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class DutchTagger
extends BaseTagger {
    public static final DutchTagger INSTANCE = new DutchTagger();
    private static final Pattern PATTERN1_A = Pattern.compile("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00e1)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])");
    private static final Pattern PATTERN1_E = Pattern.compile("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00e9)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])");
    private static final Pattern PATTERN1_I = Pattern.compile("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00ed)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])");
    private static final Pattern PATTERN1_O = Pattern.compile("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00f3)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])");
    private static final Pattern PATTERN1_U = Pattern.compile("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00fa)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])");
    private static final Pattern CHAR_PATTERN_AA = Pattern.compile("\u00e1\u00e1");
    private static final Pattern CHAR_PATTERN_AE = Pattern.compile("\u00e1\u00e9");
    private static final Pattern CHAR_PATTERN_AI = Pattern.compile("\u00e1\u00ed");
    private static final Pattern CHAR_PATTERN_AU = Pattern.compile("\u00e1\u00fa");
    private static final Pattern CHAR_PATTERN_EE = Pattern.compile("\u00e9\u00e9");
    private static final Pattern CHAR_PATTERN_EI = Pattern.compile("\u00e9\u00ed");
    private static final Pattern CHAR_PATTERN_EU = Pattern.compile("\u00e9\u00fa");
    private static final Pattern CHAR_PATTERN_IE = Pattern.compile("\u00ed\u00e9");
    private static final Pattern CHAR_PATTERN_OE = Pattern.compile("\u00f3\u00e9");
    private static final Pattern CHAR_PATTERN_OI = Pattern.compile("\u00f3\u00ed");
    private static final Pattern CHAR_PATTERN_OO = Pattern.compile("\u00f3\u00f3");
    private static final Pattern CHAR_PATTERN_OU = Pattern.compile("\u00f3\u00fa");
    private static final Pattern CHAR_PATTERN_UI = Pattern.compile("\u00fa\u00ed");
    private static final Pattern CHAR_PATTERN_UU = Pattern.compile("\u00fa\u00fa");
    private static final Pattern CHAR_PATTERN_IJ = Pattern.compile("\u00edj");
    private static final Pattern PATTERN2_A = Pattern.compile("(^|[^aeiou])\u00e1([^aeiou]|$)");
    private static final Pattern PATTERN2_E = Pattern.compile("(^|[^aeiou])\u00e9([^aeiou]|$)");
    private static final Pattern PATTERN2_I = Pattern.compile("(^|[^aeiou])\u00ed([^aeiou]|$)");
    private static final Pattern PATTERN2_O = Pattern.compile("(^|[^aeiou])\u00f3([^aeiou]|$)");
    private static final Pattern PATTERN2_U = Pattern.compile("(^|[^aeiou])\u00fa([^aeiou]|$)");
    private static final Pattern HYPHEN1_PATTERN = Pattern.compile("(^.*)-(.*$)");
    private static final Pattern HYPHEN2_PATTERN = Pattern.compile("([a-z])-([a-z])");
    private static final Set<String> alwaysNeedsHet = ImmutableSet.of((Object)"patroon", (Object)"punt", (Object)"gemaal", (Object)"weer", (Object)"kussen", (Object)"deel", (Object[])new String[0]);
    private static final Set<String> alwaysNeedsDe = ImmutableSet.of((Object)"keten", (Object)"boor", (Object)"dans");
    private static final Set<String> alwaysNeedsMrv = ImmutableSet.of((Object)"pies", (Object)"koeken", (Object)"heden");

    public DutchTagger() {
        super("/nl/dutch.dict", new Locale("nl"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        CompoundAcceptor compoundAcceptor = Dutch.getCompoundAcceptor();
        for (String word : sentenceTokens) {
            boolean ignoreSpelling = false;
            String originalWord = word;
            word = word.replace('`', '\'').replace('\u2019', '\'').replace('\u2018', '\'').replace('\u00b4', '\'');
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (l.isEmpty() && isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty()) {
                List<String> parts;
                List l2;
                String word2 = word;
                word2 = PATTERN1_A.matcher(word2).replaceAll("$1a$3");
                word2 = PATTERN1_E.matcher(word2).replaceAll("$1e$3");
                word2 = PATTERN1_I.matcher(word2).replaceAll("$1i$3");
                word2 = PATTERN1_O.matcher(word2).replaceAll("$1o$3");
                word2 = PATTERN1_U.matcher(word2).replaceAll("$1u$3");
                word2 = CHAR_PATTERN_AA.matcher(word2).replaceAll("aa");
                word2 = CHAR_PATTERN_AE.matcher(word2).replaceAll("ae");
                word2 = CHAR_PATTERN_AI.matcher(word2).replaceAll("ai");
                word2 = CHAR_PATTERN_AU.matcher(word2).replaceAll("au");
                word2 = CHAR_PATTERN_EE.matcher(word2).replaceAll("ee");
                word2 = CHAR_PATTERN_EI.matcher(word2).replaceAll("ei");
                word2 = CHAR_PATTERN_EU.matcher(word2).replaceAll("eu");
                word2 = CHAR_PATTERN_IE.matcher(word2).replaceAll("ie");
                word2 = CHAR_PATTERN_OE.matcher(word2).replaceAll("oe");
                word2 = CHAR_PATTERN_OI.matcher(word2).replaceAll("oi");
                word2 = CHAR_PATTERN_OO.matcher(word2).replaceAll("oo");
                word2 = CHAR_PATTERN_OU.matcher(word2).replaceAll("ou");
                word2 = CHAR_PATTERN_UI.matcher(word2).replaceAll("ui");
                word2 = CHAR_PATTERN_UU.matcher(word2).replaceAll("uu");
                word2 = CHAR_PATTERN_IJ.matcher(word2).replaceAll("ij");
                word2 = PATTERN2_A.matcher(word2).replaceAll("$1a$2");
                word2 = PATTERN2_E.matcher(word2).replaceAll("$1e$2");
                word2 = PATTERN2_I.matcher(word2).replaceAll("$1i$2");
                word2 = PATTERN2_O.matcher(word2).replaceAll("$1o$2");
                if ((word2 = PATTERN2_U.matcher(word2).replaceAll("$1u$2")).contains("-")) {
                    String part2 = HYPHEN1_PATTERN.matcher(word2).replaceAll("$2");
                    List p2 = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(part2));
                    if (!p2.isEmpty()) {
                        word2 = HYPHEN2_PATTERN.matcher(word2).replaceAll("$1$2");
                    }
                }
                if (!word2.equals(word) && !(l2 = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(word2))).isEmpty()) {
                    this.addTokens(l2, l);
                    ignoreSpelling = true;
                }
                if (l.isEmpty() && word.length() > 5 && (parts = compoundAcceptor.getParts(word)).size() == 2) {
                    String part1 = parts.get(0);
                    String part2 = parts.get(1);
                    List<AnalyzedTokenReadings> part2ReadingsList = this.tag(Collections.singletonList(part2));
                    AnalyzedTokenReadings part2Readings = part2ReadingsList.get(0);
                    String part1lc = part1.toLowerCase();
                    for (AnalyzedToken part2Reading : part2Readings) {
                        if (part2Reading.getPOSTag() == null) continue;
                        if (part1.endsWith("-") && part2Reading.getPOSTag().startsWith("ENM:LOC")) {
                            l.add(new AnalyzedToken(word, part2Reading.getPOSTag(), part2));
                            break;
                        }
                        if (!part2Reading.getPOSTag().startsWith("ZNW")) continue;
                        String tag = alwaysNeedsHet.contains(part2) ? "ZNW:EKV:HET" : (alwaysNeedsDe.contains(part2) ? "ZNW:EKV:DE_" : (alwaysNeedsMrv.contains(part2) ? "ZNW:MRV:DE_" : part2Reading.getPOSTag()));
                        l.add(new AnalyzedToken(word, tag, part1lc + part2Reading.getLemma()));
                        if (!alwaysNeedsHet.contains(part2) && !alwaysNeedsDe.contains(part2) && !alwaysNeedsMrv.contains(part2)) continue;
                        break;
                    }
                }
            }
            word = originalWord;
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(originalWord, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (ignoreSpelling) {
                if (isLowercase) {
                    List fu = this.asAnalyzedTokenListForTaggedWords(StringTools.uppercaseFirstChar((String)originalWord), this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)originalWord)));
                    if (fu.isEmpty()) {
                        atr.ignoreSpelling();
                    } else {
                        l.clear();
                        l.add(new AnalyzedToken(originalWord, null, null));
                    }
                } else {
                    atr.ignoreSpelling();
                }
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    public List<AnalyzedToken> getPostags(String word) {
        return this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

