/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PortugueseClicheRule
extends AbstractSimpleReplaceRule2 {
    public static final String PORTUGUESE_CLICHE_RULE = "PT_CLICHE_REPLACE";
    private static final String FILE_NAME = "/pt/cliches.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public final String getFileName() {
        return FILE_NAME;
    }

    public PortugueseClicheRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Portuguese());
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>quente como uma fornalha</marker>"), Example.fixed((String)"<marker>quente</marker>"));
    }

    public final String getId() {
        return PORTUGUESE_CLICHE_RULE;
    }

    public String getDescription() {
        return "Frases-feitas e express\u00f5es idiom\u00e1ticas.";
    }

    public String getShort() {
        return "Frase-feita";
    }

    public String getSuggestion() {
        return " \u00e9 uma frase-feita. \u00c9 prefer\u00edvel dizer ";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

