/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PortugueseReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String PORTUGUESE_SIMPLE_REPLACE_RULE = "PT_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = PortugueseReplaceRule.load((String)"/pt/replace.txt");
    private static final Locale PT_LOCALE = new Locale("pt");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PortugueseReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>device</marker>"), Example.fixed((String)"<marker>dispositivo</marker>"));
    }

    public final String getId() {
        return PORTUGUESE_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras estrangeiras facilmente confundidas em Portugu\u00eas";
    }

    public String getShort() {
        return "Estrangeirismo";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " \u00e9 um estrangeirismo. Em Portugu\u00eas \u00e9 mais comum usar: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

