/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.pt.PortugueseAccentuationDataLoader;
import org.languagetool.tools.StringTools;

public class PortugueseAccentuationCheckRule
extends Rule {
    private static final Pattern PREPOSICAO_DE = Pattern.compile("de|d[a|o]s?");
    private static final Pattern ARTIGO_O_MS = Pattern.compile("o|O");
    private static final Pattern ARTIGO_O_FS = Pattern.compile("a|A");
    private static final Pattern ARTIGO_O_MP = Pattern.compile("as|As");
    private static final Pattern ARTIGO_O_FP = Pattern.compile("os|Os");
    private static final Pattern DETERMINANTE = Pattern.compile("D[^R].*");
    private static final Pattern DETERMINANTE_MS = Pattern.compile("D[^R].[MC][SN].*");
    private static final Pattern DETERMINANTE_FS = Pattern.compile("D[^R].[FC][SN].*");
    private static final Pattern DETERMINANTE_MP = Pattern.compile("D[^R].[MC][PN].*");
    private static final Pattern DETERMINANTE_FP = Pattern.compile("D[^R].[FC][PN].*");
    private static final Pattern NOME_MS = Pattern.compile("NC[MC][SN].*");
    private static final Pattern NOME_FS = Pattern.compile("NC[FC][SN].*");
    private static final Pattern NOME_MP = Pattern.compile("NC[MC][PN].*");
    private static final Pattern NOME_FP = Pattern.compile("NC[FC][PN].*");
    private static final Pattern ADJETIVO_MS = Pattern.compile("A..[MC][SN].*|V.P..SM.?|PX.MS.*");
    private static final Pattern ADJETIVO_FS = Pattern.compile("A..[FC][SN].*|V.P..SF.?|PX.FS.*");
    private static final Pattern ADJETIVO_MP = Pattern.compile("A..[MC][PN].*|V.P..PM.?|PX.MP.*");
    private static final Pattern ADJETIVO_FP = Pattern.compile("A..[FC][PN].*|V.P..PF.?|PX.FP.*");
    private static final Pattern INFINITIVO = Pattern.compile("V.N.*");
    private static final Pattern VERBO_CONJUGADO = Pattern.compile("V.[^NGP].*|_GV_");
    private static final Pattern PARTICIPIO_MS = Pattern.compile("V.P.*SM.?");
    private static final Pattern GRUPO_VERBAL = Pattern.compile("_GV_");
    private static final Pattern VERBO_3S = Pattern.compile("V...3S..?");
    private static final Pattern NOT_IN_PREV_TOKEN = Pattern.compile("V..*|PP.*|P0.*|V.P.*");
    private static final Pattern BEFORE_ADJECTIVE_MS = Pattern.compile("SPS00|D[^R].[MC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FS = Pattern.compile("SPS00|D[^R].[FC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_MP = Pattern.compile("SPS00|D[^R].[MC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FP = Pattern.compile("SPS00|D[^R].[FC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern GN = Pattern.compile(".*_GN_.*|<?/?N[CP].*");
    private static final Pattern EXCEPCOES_ANTES_DE = Pattern.compile("forma|manera|por|costat", 66);
    private static final Pattern PRONOME_PESSOAL = Pattern.compile("P0.{6}|PP3CN000|PP3NN000|PP3CP000|PP3CSD00");
    private static final Map<String, AnalyzedTokenReadings> relevantWords = new PortugueseAccentuationDataLoader().loadWords("/pt/verbos_sem_acento_nomes_com_acento.txt");
    private static final Map<String, AnalyzedTokenReadings> relevantWords2 = new PortugueseAccentuationDataLoader().loadWords("/pt/verbos_sem_acento_adj_com_acento.txt");

    public PortugueseAccentuationCheckRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.CONFUSED_WORDS.getCategory(messages));
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    public String getId() {
        return "ACCENTUATION_CHECK_PT";
    }

    public String getDescription() {
        return "Confus\u00e3o com acentos gr\u00e1ficos";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String token = i == 1 ? tokens[i].getToken().toLowerCase() : tokens[i].getToken();
            String prevToken = tokens[i - 1].getToken();
            String prevPrevToken = "";
            if (i > 2) {
                prevPrevToken = tokens[i - 2].getToken();
            }
            String nextToken = "";
            if (i < tokens.length - 1) {
                nextToken = tokens[i + 1].getToken();
            }
            String nextNextToken = "";
            if (i < tokens.length - 2) {
                nextNextToken = tokens[i + 2].getToken();
            }
            boolean isRelevantWord = false;
            boolean isRelevantWord2 = false;
            if (StringTools.isEmpty((String)token)) continue;
            if (relevantWords.containsKey(token)) {
                isRelevantWord = true;
            }
            if (relevantWords2.containsKey(token)) {
                isRelevantWord2 = true;
            }
            if (!isRelevantWord && !isRelevantWord2 || this.matchPostagRegexp(tokens[i - 1], PRONOME_PESSOAL) && !prevToken.startsWith("-")) continue;
            String replacement = null;
            Matcher mPreposicaoDE = PREPOSICAO_DE.matcher(nextToken);
            Matcher mExcepcoesDE = EXCEPCOES_ANTES_DE.matcher(nextNextToken);
            Matcher mArtigoOMS = ARTIGO_O_MS.matcher(prevToken);
            Matcher mArtigoOFS = ARTIGO_O_FS.matcher(prevToken);
            Matcher mArtigoOMP = ARTIGO_O_MP.matcher(prevToken);
            Matcher mArtigoOFP = ARTIGO_O_FP.matcher(prevToken);
            if (isRelevantWord && !this.matchPostagRegexp(tokens[i], GN)) {
                if (tokens[i - 1].hasPosTag("SPS00") && !tokens[i - 1].hasPosTag("RG") && !this.matchPostagRegexp(tokens[i - 1], DETERMINANTE) && !this.matchPostagRegexp(tokens[i], INFINITIVO)) {
                    replacement = relevantWords.get(token).getToken();
                } else if (this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_MS) && this.matchPostagRegexp(relevantWords.get(token), NOME_MS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_MP) && this.matchPostagRegexp(relevantWords.get(token), NOME_MP) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_FS) && this.matchPostagRegexp(relevantWords.get(token), NOME_FS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_FP) && this.matchPostagRegexp(relevantWords.get(token), NOME_FP)) {
                    replacement = relevantWords.get(token).getToken();
                } else if (i > 2 && this.matchPostagRegexp(tokens[i - 2], VERBO_CONJUGADO) && (this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_MS) && this.matchPostagRegexp(relevantWords.get(token), NOME_MS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_MP) && this.matchPostagRegexp(relevantWords.get(token), NOME_MP) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_FS) && this.matchPostagRegexp(relevantWords.get(token), NOME_FS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANTE_FP) && this.matchPostagRegexp(relevantWords.get(token), NOME_FP))) {
                    replacement = relevantWords.get(token).getToken();
                } else if (i > 2 && this.matchPostagRegexp(tokens[i - 2], VERBO_CONJUGADO) && (mArtigoOMS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MS) || mArtigoOMP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MP) || mArtigoOFS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FS) || mArtigoOFP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FP))) {
                    replacement = relevantWords.get(token).getToken();
                } else if (!(this.matchPostagRegexp(tokens[i], PARTICIPIO_MS) || this.matchPostagRegexp(tokens[i - 1], NOT_IN_PREV_TOKEN) || i >= tokens.length - 2 || this.matchPostagRegexp(tokens[i + 2], INFINITIVO) || mExcepcoesDE.matches() || tokens[i - 1].hasPosTag("RG"))) {
                    replacement = relevantWords.get(token).getToken();
                } else if ((mArtigoOMS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MS) || mArtigoOFS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FS) || mArtigoOMP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MP) || mArtigoOFP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FP)) && mPreposicaoDE.matches()) {
                    replacement = relevantWords.get(token).getToken();
                } else if (i < tokens.length - 1 && (this.matchPostagRegexp(relevantWords.get(token), NOME_MS) && this.matchPostagRegexp(tokens[i + 1], ADJETIVO_MS) || this.matchPostagRegexp(relevantWords.get(token), NOME_FS) && this.matchPostagRegexp(tokens[i + 1], ADJETIVO_FS) || this.matchPostagRegexp(relevantWords.get(token), NOME_MP) && this.matchPostagRegexp(tokens[i + 1], ADJETIVO_MP) || this.matchPostagRegexp(relevantWords.get(token), NOME_FP) && this.matchPostagRegexp(tokens[i + 1], ADJETIVO_FP))) {
                    replacement = relevantWords.get(token).getToken();
                } else if (this.matchPostagRegexp(relevantWords.get(token), NOME_MS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MS) && !this.matchPostagRegexp(tokens[i], VERBO_3S) && !this.matchPostagRegexp(tokens[i], GRUPO_VERBAL) || this.matchPostagRegexp(relevantWords.get(token), NOME_FS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FS) && !this.matchPostagRegexp(tokens[i], VERBO_3S) || this.matchPostagRegexp(relevantWords.get(token), NOME_MP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MP) || this.matchPostagRegexp(relevantWords.get(token), NOME_FP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FP)) {
                    replacement = relevantWords.get(token).getToken();
                } else if (nextToken.equals("que") && i > 2 && (this.matchPostagRegexp(relevantWords.get(token), NOME_MS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MS) && this.matchPostagRegexp(tokens[i - 2], DETERMINANTE_MS) || this.matchPostagRegexp(relevantWords.get(token), NOME_FS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FS) && this.matchPostagRegexp(tokens[i - 2], DETERMINANTE_FS) || this.matchPostagRegexp(relevantWords.get(token), NOME_MP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MP) && this.matchPostagRegexp(tokens[i - 2], DETERMINANTE_MP) || this.matchPostagRegexp(relevantWords.get(token), NOME_FP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FP) && this.matchPostagRegexp(tokens[i - 2], DETERMINANTE_FP))) {
                    replacement = relevantWords.get(token).getToken();
                } else if (nextToken.equals("que") && (mArtigoOMS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MS) || mArtigoOFS.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FS) || mArtigoOMP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_MP) || mArtigoOFP.matches() && this.matchPostagRegexp(relevantWords.get(token), NOME_FP))) {
                    replacement = relevantWords.get(token).getToken();
                }
                if (i > 2 && tokens[i - 2].hasPosTag("SPS00") && !tokens[i - 2].hasPosTag("RG") && (this.matchPostagRegexp(relevantWords.get(token), NOME_MS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MS) || this.matchPostagRegexp(relevantWords.get(token), NOME_FS) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FS) || this.matchPostagRegexp(relevantWords.get(token), NOME_MP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_MP) || this.matchPostagRegexp(relevantWords.get(token), NOME_FP) && this.matchPostagRegexp(tokens[i - 1], ADJETIVO_FP))) {
                    replacement = relevantWords.get(token).getToken();
                }
            }
            if (isRelevantWord2 && !this.matchPostagRegexp(tokens[i], GN)) {
                if (this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MS) && this.matchPostagRegexp(tokens[i - 1], NOME_MS) && !tokens[i - 1].hasPosTag("_GN_FS") && this.matchPostagRegexp(tokens[i], VERBO_CONJUGADO) && !this.matchPostagRegexp(tokens[i], VERBO_3S) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FS) && prevPrevToken.equalsIgnoreCase("de") && (prevToken.equals("maneira") || prevToken.equals("forma")) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MP) && this.matchPostagRegexp(tokens[i - 1], NOME_MP) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FP) && this.matchPostagRegexp(tokens[i - 1], NOME_FP)) {
                    replacement = relevantWords2.get(token).getToken();
                } else if (i < tokens.length - 1 && !prevToken.equals("que") && !this.matchPostagRegexp(tokens[i - 1], NOT_IN_PREV_TOKEN) && (this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MS) && this.matchPostagRegexp(tokens[i + 1], NOME_MS) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_MS) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FS) && this.matchPostagRegexp(tokens[i + 1], NOME_FS) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_FS) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MP) && this.matchPostagRegexp(tokens[i + 1], NOME_MP) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_MP) || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FP) && this.matchPostagRegexp(tokens[i + 1], NOME_FP) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_FP))) {
                    replacement = relevantWords2.get(token).getToken();
                } else if (i < tokens.length - 1 && (this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MS) && this.matchPostagRegexp(tokens[i + 1], NOME_MS) && mArtigoOMS.matches() || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FS) && this.matchPostagRegexp(tokens[i + 1], NOME_FS) && mArtigoOFS.matches() || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_MP) && this.matchPostagRegexp(tokens[i + 1], NOME_MP) && mArtigoOMP.matches() || this.matchPostagRegexp(relevantWords2.get(token), ADJETIVO_FP) && this.matchPostagRegexp(tokens[i + 1], NOME_FP) && mArtigoOFP.matches())) {
                    replacement = relevantWords2.get(token).getToken();
                }
            }
            if (replacement == null) continue;
            String msg = "Se \u00e9 um nome ou um adjectivo, tem acento.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getEndPos(), "Se \u00e9 um nome ou um adjectivo, tem acento.", "Falta um acento");
            ruleMatch.setSuggestedReplacement(replacement);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public void reset() {
    }
}

