/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.Unit;
import org.languagetool.rules.AbstractUnitConversionRule;
import tech.units.indriya.unit.Units;

public class PortugueseUnitConversionRule
extends AbstractUnitConversionRule {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.GERMANY);

    public PortugueseUnitConversionRule(ResourceBundle messages) {
        super(messages);
        this.format.setMaximumFractionDigits(2);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.addUnit("(qui|ki)lo(grama)?", (Unit)Units.KILOGRAM, "quilogramas", 1.0, true);
        this.addUnit("grama", (Unit)Units.KILOGRAM, "gramas", 0.001, true);
        this.addUnit("toneladas?", (Unit)Units.KILOGRAM, "toneladas", 1000.0, true);
        this.addUnit("libras?", POUND, "libras", 1.0, false);
        this.addUnit("milhas?", MILE, "milhas", 1.0, false);
        this.addUnit("jardas?", YARD, "jardas", 1.0, false);
        this.addUnit("p\u00e9s?", FEET, "p\u00e9s", 1.0, false);
        this.addUnit("polegadas?", INCH, "polegadas", 1.0, false);
        this.addUnit("(Kilometros por Hora)", Units.KILOMETRE_PER_HOUR, "quil\u00f3metros por hora", 1.0, true);
        this.addUnit("milhas por hora", MILE.divide(Units.HOUR), "milhas por hora", 1.0, false);
        this.addUnit("metros?", Units.METRE, "metros", 1.0, true);
        this.addUnit("kil\u00f3metros?|Quil\u00f3metros?", Units.METRE, "quil\u00f3metros", 1000.0, true);
        this.addUnit("dec\u00edmetros?", Units.METRE, "dec\u00edmetros", 0.1, false);
        this.addUnit("cent\u00edmetros?", Units.METRE, "cent\u00edmetros", 0.01, true);
        this.addUnit("mil\u00edmetros?", Units.METRE, "mil\u00edmetros", 0.001, true);
        this.addUnit("micr\u00f3metros?", Units.METRE, "micr\u00f3metros", 1.0E-6, true);
        this.addUnit("nan\u00f3metros?", Units.METRE, "nan\u00f3metros", 1.0E-9, true);
        this.addUnit("pic\u00f3metros?", Units.METRE, "pic\u00f3metros", 1.0E-12, true);
        this.addUnit("fentometros?", Units.METRE, "fectometros", 1.0E-15, true);
        this.addUnit("metros? quadrados?", Units.SQUARE_METRE, "metros quadrados", 1.0, true);
        this.addUnit("hect\u00e1r(es)?", Units.SQUARE_METRE, "h\u00e9ctares", 10000.0, true);
        this.addUnit("area?", Units.SQUARE_METRE, "ares", 100.0, true);
        this.addUnit("(kil\u00f3metros?|quil\u00f3metros?) quadrados?", Units.SQUARE_METRE, "quil\u00f3metros quadrados", 1000000.0, true);
        this.addUnit("dec\u00edmetros?", Units.SQUARE_METRE, "dec\u00edmetros quadrados", 0.01, false);
        this.addUnit("cent\u00edmetros? quadrados?", Units.SQUARE_METRE, "cent\u00edmetros quadrados", 1.0E-4, true);
        this.addUnit("mil\u00edmetros? quadrados?", Units.SQUARE_METRE, "mil\u00edmetros quadrados", 1.0E-6, true);
        this.addUnit("micr\u00f3metros? quadrados?", Units.SQUARE_METRE, "micr\u00f3metros quadrados", 1.0E-12, true);
        this.addUnit("nan\u00f3metros? quadrados?", Units.SQUARE_METRE, "nan\u00f3metros quadrados", 1.0E-18, true);
        this.addUnit("metros? c\u00fabicos?", Units.CUBIC_METRE, "metros c\u00fabicos", 1.0, true);
        this.addUnit("quil\u00f3metros? c\u00fabicos?", Units.CUBIC_METRE, "quil\u00f3metros c\u00fabicos", 1.0E9, true);
        this.addUnit("dec\u00edmetros? c\u00fabicos?", Units.CUBIC_METRE, "dec\u00edmetros c\u00fabicos", 0.001, false);
        this.addUnit("cent\u00edmetros? c\u00fabicos?", Units.CUBIC_METRE, "cent\u00edmetros c\u00fabicos", 1.0E-6, true);
        this.addUnit("mil\u00edmetros? c\u00fabicos?", Units.CUBIC_METRE, "mil\u00edmetros c\u00fabicos", 1.0E-9, true);
        this.addUnit("micr\u00f3metros? c\u00fabicos?", Units.CUBIC_METRE, "micr\u00f3metros c\u00fabicos", 1.0E-18, true);
        this.addUnit("nan\u00f3metros? c\u00fabicos?", Units.CUBIC_METRE, "nan\u00f3metros c\u00fabicos", 1.0E-27, true);
        this.addUnit("litros?", Units.LITRE, "litros", 1.0, true);
        this.addUnit("mil\u00edlitros?", Units.LITRE, "mil\u00edlitros", 0.001, true);
        this.addUnit("(?:Graus)? Fahrenheit", FAHRENHEIT, "graus Fahrenheit", 1.0, false);
        this.addUnit("(?:Graus)? Celsi[ou]s", (Unit)Units.CELSIUS, "graus Celsios", 1.0, true);
    }

    public String getId() {
        return "UNIDADES_METRICAS";
    }

    public String getDescription() {
        return "Sugere ou verifica informa\u00e7\u00f5es equivalentes \u00e0 m\u00e9trica de unidades de medida espec\u00edficas.";
    }

    protected String getMessage(AbstractUnitConversionRule.Message message) {
        switch (message) {
            case CHECK: {
                return "Esta convers\u00e3o parece estar errada. Quer que isso seja corrigido automaticamente?";
            }
            case SUGGESTION: {
                return "Deseja adicionar automaticamente uma convers\u00e3o ao sistema m\u00e9trico?";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "A unidade usada nesta convers\u00e3o n\u00e3o foi reconhecida.";
            }
            case UNIT_MISMATCH: {
                return "Estas unidades n\u00e3o s\u00e3o compat\u00edveis.";
            }
        }
        throw new RuntimeException("Unknown message type." + message);
    }

    protected String getShortMessage(AbstractUnitConversionRule.Message message) {
        switch (message) {
            case CHECK: {
                return "Convers\u00e3o errada. Corrigir automaticamente?";
            }
            case SUGGESTION: {
                return "Adicionar equival\u00eancia de m\u00e9trica?";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "Unidade desconhecida.";
            }
            case UNIT_MISMATCH: {
                return "Unidade n\u00e3o relacionada.";
            }
        }
        throw new RuntimeException("Unknown message type." + message);
    }

    protected NumberFormat getNumberFormat() {
        return this.format;
    }
}

