/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ReadabilityRule;

public class PortugueseReadabilityRule
extends ReadabilityRule {
    boolean tooEasyTest;

    public PortugueseReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest) {
        this(messages, lang, userConfig, tooEasyTest, -1, false);
    }

    public PortugueseReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level) {
        this(messages, lang, userConfig, tooEasyTest, level, false);
    }

    public PortugueseReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, boolean defaultOn) {
        this(messages, lang, userConfig, tooEasyTest, -1, defaultOn);
    }

    public PortugueseReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level, boolean defaultOn) {
        super(messages, lang, userConfig, tooEasyTest, level, defaultOn);
        super.setCategory(new Category(new CategoryId("TEXT_ANALYSIS"), "An\u00e1lise de Texto", Category.Location.INTERNAL, false));
        this.tooEasyTest = tooEasyTest;
    }

    public String getId() {
        if (this.tooEasyTest) {
            return "READABILITY_RULE_SIMPLE_PT";
        }
        return "READABILITY_RULE_DIFFICULT_PT";
    }

    public String getDescription() {
        if (this.tooEasyTest) {
            return "Legibilidade: texto demasiado simples";
        }
        return "Legibilidade: texto demasiado complexo";
    }

    private static String printMessageLevel(int level) {
        String sLevel = null;
        if (level == 0) {
            sLevel = "Muito complexo";
        } else if (level == 1) {
            sLevel = "Complexo";
        } else if (level == 2) {
            sLevel = "Moderadamente complexo";
        } else if (level == 3) {
            sLevel = "Meio-termo";
        } else if (level == 4) {
            sLevel = "Moderadamente simples";
        } else if (level == 5) {
            sLevel = "Simples";
        } else if (level == 6) {
            sLevel = "Muito simples";
        }
        if (sLevel != null) {
            return " {N\u00edvel " + level + ": " + sLevel + "}";
        }
        return "";
    }

    protected String getMessage(int level, int FRE, int ASL, int ASW) {
        String few;
        String simple;
        if (this.tooEasyTest) {
            simple = "f\u00e1cil";
            few = "poucas";
        } else {
            simple = "dif\u00edcil";
            few = "muitas";
        }
        return "Legibilidade {FRE: " + FRE + ", ASL: " + ASL + ", ASW: " + ASW + "}: O texto deste par\u00e1grafo \u00e9 " + simple + PortugueseReadabilityRule.printMessageLevel(level) + ". Tem " + few + " palavras por frase e " + few + " s\u00edlabas por palavra.";
    }

    public String getConfigureText() {
        return "N\u00edvel de legibilidade 0 (muito dif\u00edcil) a 6 (muito f\u00e1cil):";
    }

    protected double getFleschReadingEase(double ASL, double ASW) {
        return 206.84 - 1.02 * ASL - 60.0 * ASW;
    }

    private static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == '\u00e1' || c == '\u00e9' || c == '\u00ed' || c == '\u00f3' || c == '\u00fa' || c == '\u00e0' || c == '\u00c1' || c == '\u00c9' || c == '\u00cd' || c == '\u00d3' || c == '\u00da' || c == '\u00c0' || c == '\u00e2' || c == '\u00ea' || c == '\u00f4' || c == '\u00c2' || c == '\u00ca' || c == '\u00d4' || c == '\u00dc';
    }

    protected int simpleSyllablesCount(String word) {
        if (word.length() == 0) {
            return 0;
        }
        int nSyllables = 0;
        if (PortugueseReadabilityRule.isVowel(word.charAt(0))) {
            ++nSyllables;
        }
        boolean lastDouble = false;
        for (int i = 1; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (PortugueseReadabilityRule.isVowel(c)) {
                char cl = word.charAt(i - 1);
                if (lastDouble) {
                    ++nSyllables;
                    lastDouble = false;
                    continue;
                }
                if ((c == '\u00e3' || c == '\u00f5') && (cl == 'e' || cl == 'o') || c == 'a' && (cl == 'e' || cl == 'i' || cl == '\u00ed' || cl == 'o' || cl == 'u' || cl == '\u00fa') || c == 'e' && (cl == 'e' || cl == 'i' || cl == '\u00ed' || cl == 'o' || cl == 'a' || cl == 'u') || c == 'i' && (cl == 'a' || cl == 'e' || cl == 'o' || cl == 'u' || cl == '\u00e1' || cl == '\u00e9') || c == '\u00ed' && (cl == 'a' || cl == 'e') || c == 'o' && (cl == 'a' || cl == '\u00e1' || cl == 'e' || cl == '\u00e9' || cl == 'i' || cl == '\u00ed' || cl == 'u') || c == 'u' && (cl == 'a' || cl == '\u00e1' || cl == 'e' || cl == '\u00e9' || cl == 'i' || cl == 'o') || c == '\u00fa' && (cl == 'a' || cl == 'e' || cl == 'o')) {
                    lastDouble = true;
                    continue;
                }
                ++nSyllables;
                lastDouble = false;
                continue;
            }
            lastDouble = false;
        }
        return nSyllables == 0 ? 1 : nSyllables;
    }
}

