/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class BrazilianPortugueseReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String BRAZILIAN_PORTUGUESE_SIMPLE_REPLACE_RULE = "PT_BR_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = BrazilianPortugueseReplaceRule.loadFromPath((String)"/pt/pt-BR/replace.txt");
    private static final Locale PT_BR_LOCALE = new Locale("pt-BR");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public BrazilianPortugueseReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.REGIONALISMS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"Onde est\u00e1 o <marker>toilet</marker>?"), Example.fixed((String)"Onde est\u00e1 o <marker>banheiro</marker>?"));
    }

    public final String getId() {
        return BRAZILIAN_PORTUGUESE_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras portuguesas facilmente confundidas com as do Brasil";
    }

    public String getShort() {
        return "Palavra de Portugu\u00eas do Brasil";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "'" + tokenStr + "' \u00e9 uma express\u00e3o de Portugal, em Portugu\u00eas do Brasil utiliza-se: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_BR_LOCALE;
    }
}

