/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseArchaismsRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_ARCHAISMS_REPLACE = "PT_ARCHAISMS_REPLACE";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public final List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public PortugueseArchaismsRule(ResourceBundle messages, String path) {
        super(messages, (Language)new Portuguese());
        this.path = Objects.requireNonNull(path);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
    }

    public String getId() {
        return PT_ARCHAISMS_REPLACE;
    }

    public String getDescription() {
        return "Palavras arcaicas evit\u00e1veis";
    }

    public String getShort() {
        return "Arca\u00edsmo";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 um arca\u00edsmo. \u00c9 prefer\u00edvel dizer $suggestions.";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Arca%C3%ADsmo");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

