/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseClicheRule
extends AbstractSimpleReplaceRule2 {
    public static final String PORTUGUESE_CLICHE_RULE = "PT_CLICHE_REPLACE";
    private static final String FILE_NAME = "/pt/cliches.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public PortugueseClicheRule(ResourceBundle messages) {
        super(messages, (Language)new Portuguese());
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>quente como uma fornalha</marker>"), Example.fixed((String)"<marker>quente</marker>"));
    }

    public String getId() {
        return PORTUGUESE_CLICHE_RULE;
    }

    public String getDescription() {
        return "Frases-feitas e express\u00f5es idiom\u00e1ticas";
    }

    public String getShort() {
        return "Frase-feita";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 uma frase-feita. \u00c9 prefer\u00edvel dizer $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Clich\u00ea");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

