/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseWordinessRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_WORDINESS_REPLACE = "PT_WORDINESS_REPLACE";
    private static final String FILE_NAME = "/pt/wordiness.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public PortugueseWordinessRule(ResourceBundle messages) {
        super(messages, (Language)new Portuguese());
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Raramente \u00e9 o caso em que acontece</marker> isto."), Example.fixed((String)"<marker>Raramente acontece</marker> isto."));
    }

    public String getId() {
        return PT_WORDINESS_REPLACE;
    }

    public String getDescription() {
        return "2. Express\u00f5es prolixas";
    }

    public String getShort() {
        return "Express\u00e3o prolixa";
    }

    public String getMessage() {
        return "'$match' \u00e9 uma express\u00e3o prolixa. \u00c9 prefer\u00edvel dizer $suggestions.";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/V%C3%ADcio_de_linguagem#Prolixidade_ou_preciosismo");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

