/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseClicheRule
extends AbstractSimpleReplaceRule2 {
    public static final String PORTUGUESE_CLICHE_RULE = "PT_CLICHE_REPLACE";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public final List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public PortugueseClicheRule(ResourceBundle messages, String path, Language language) {
        super(messages, language);
        this.path = Objects.requireNonNull(path);
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.useSubRuleSpecificIds();
        this.addExamplePair(Example.wrong((String)"<marker>quente como uma fornalha</marker>"), Example.fixed((String)"<marker>quente</marker>"));
    }

    public String getId() {
        return PORTUGUESE_CLICHE_RULE;
    }

    public String getDescription() {
        return "Frases-feitas e express\u00f5es idiom\u00e1ticas: $match";
    }

    public String getShort() {
        return "Frase-feita";
    }

    public String getMessage() {
        return "\"$match\" \u00e9 uma frase-feita. \u00c9 prefer\u00edvel dizer $suggestions.";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Clich\u00ea");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

