/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.pt.ConfusionPairsDataLoader;
import org.languagetool.tools.StringTools;

public class ConfusionCheckFilter
extends RuleFilter {
    private final Map<String, AnalyzedTokenReadings> relevantWordsPT = new ConfusionPairsDataLoader().loadWords(this.getFilepathsPT());
    private final Map<String, AnalyzedTokenReadings> relevantWordsBR = new ConfusionPairsDataLoader().loadWords(this.getFilepathsBR());
    private static final Pattern MS = Pattern.compile("NC[MC][SN]000|A..[MC][SN].|V.P..SM");
    private static final Pattern FS = Pattern.compile("NC[FC][SN]000|A..[FC][SN].|V.P..SF");
    private static final Pattern MP = Pattern.compile("NC[MC][PN]000|A..[MC][PN].|V.P..PM");
    private static final Pattern FP = Pattern.compile("NC[FC][PN]000|A..[FC][PN].|V.P..PF");
    private static final Pattern CP = Pattern.compile("NC[MFC][PN]000|A..[MFC][PN].|V.P..P.");
    private static final Pattern CS = Pattern.compile("NC[MFC][SN]000|A..[MFC][SN].|V.P..S.");

    private List<String> getFilepathsBR() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/pt/confusion_pairs.txt");
        paths.add("/pt/pt-BR/confusion_pairs.txt");
        return paths;
    }

    private List<String> getFilepathsPT() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/pt/confusion_pairs.txt");
        paths.add("/pt/pt-PT/confusion_pairs.txt");
        return paths;
    }

    private String getLanguageVariantCode(RuleMatch match) {
        PatternRule pr = (PatternRule)match.getRule();
        return pr.getLanguage().getShortCodeWithCountryAndVariant();
    }

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        String variant;
        Map<String, AnalyzedTokenReadings> relevantWords;
        Pattern desiredGenderNumberPattern = null;
        String replacement = null;
        String postag = this.getRequired("postag", arguments);
        String form = this.getRequired("form", arguments).toLowerCase();
        String gendernumberFrom = this.getOptional("gendernumberFrom", arguments);
        if (gendernumberFrom != null) {
            int i = Integer.parseInt(gendernumberFrom);
            if (i < 1 || i > patternTokens.length) {
                throw new IllegalArgumentException("ConfusionCheckFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + i);
            }
            AnalyzedTokenReadings atr = patternTokens[i - 1];
            if (atr.matchesPosTagRegex("[NAPD].+MS.*|V.P..SM")) {
                desiredGenderNumberPattern = MS;
            } else if (atr.matchesPosTagRegex("[NAPD].+MP.*|V.P..PM")) {
                desiredGenderNumberPattern = MP;
            } else if (atr.matchesPosTagRegex("[NAPD].+FS.*|V.P..SF")) {
                desiredGenderNumberPattern = FS;
            } else if (atr.matchesPosTagRegex("[NAPD].+FP.*|V.P..PF")) {
                desiredGenderNumberPattern = FP;
            } else if (atr.matchesPosTagRegex("[NAPD].+CP.*|V.P..P.")) {
                desiredGenderNumberPattern = CP;
            } else if (atr.matchesPosTagRegex("[NAPD].+CS.*|V.P..S.")) {
                desiredGenderNumberPattern = CS;
            }
        }
        if ((relevantWords = Objects.equals(variant = this.getLanguageVariantCode(match), "pt-BR") ? this.relevantWordsBR : (Objects.equals(variant, "pt-PT") ? this.relevantWordsPT : this.relevantWordsPT)).containsKey(form) && relevantWords.get(form).matchesPosTagRegex(postag)) {
            if (desiredGenderNumberPattern != null) {
                Matcher m = desiredGenderNumberPattern.matcher(((AnalyzedToken)relevantWords.get(form).getReadings().get(0)).getPOSTag());
                if (!m.matches()) {
                    return null;
                }
                replacement = relevantWords.get(form).getToken();
            } else if (gendernumberFrom == null) {
                replacement = relevantWords.get(form).getToken();
            }
        }
        if (replacement != null) {
            String message = match.getMessage();
            if (!StringTools.hasDiacritics(replacement) || StringTools.hasDiacritics((String)form)) {
                message = message.replace("se escribe con tilde", "se escribe de otra manera");
            }
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            String suggestion = ((String)match.getSuggestedReplacements().get(0)).replace("{suggestion}", replacement);
            suggestion = suggestion.replace("{Suggestion}", StringTools.uppercaseFirstChar((String)replacement));
            suggestion = suggestion.replace("{SUGGESTION}", replacement.toUpperCase());
            ruleMatch.setSuggestedReplacement(suggestion);
            return ruleMatch;
        }
        return null;
    }
}

