/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;
import org.languagetool.tools.StringTools;

public class PortugueseEnclisisFilter
extends RuleFilter {
    protected PortugueseSynthesizer getSynthesizer() {
        return PortugueseSynthesizer.INSTANCE;
    }

    private String convertPronounToAccusative(String pronounTag) {
        if (pronounTag.endsWith("N00")) {
            return pronounTag.substring(0, pronounTag.length() - 3) + "A00";
        }
        return pronounTag;
    }

    private List<String> getPronounTags(AnalyzedTokenReadings pronounReadings, String verbText, boolean convertToAccusative) {
        ArrayList<String> pronounTags = new ArrayList<String>(Collections.emptyList());
        for (AnalyzedToken pronounToken : pronounReadings) {
            String pronounText = pronounToken.getToken();
            if (pronounText.equals("nos")) {
                pronounTags.add("PP1CPO00");
                if (!verbText.endsWith("m") && !verbText.endsWith("\u00e3o") && !verbText.endsWith("\u00f5e")) break;
                pronounTags.add("PP3MPA00");
                break;
            }
            String posTag = pronounToken.getPOSTag();
            if (posTag == null || !posTag.startsWith("PP")) continue;
            if (convertToAccusative) {
                posTag = this.convertPronounToAccusative(posTag);
            }
            pronounTags.add(posTag);
        }
        return pronounTags;
    }

    @NotNull
    private ArrayList<String> getVerbForms(AnalyzedTokenReadings verbStemTokenReadings, List<String> pronounTags) throws IOException {
        HashSet suggestions = new HashSet(Collections.emptyList());
        boolean isTitleCase = StringTools.isCapitalizedWord((String)verbStemTokenReadings.getToken());
        boolean isAllCaps = StringTools.isAllUppercase((String)verbStemTokenReadings.getToken());
        for (AnalyzedToken at : verbStemTokenReadings.getReadings()) {
            String posTag = at.getPOSTag();
            if (posTag == null || !posTag.startsWith("V")) continue;
            for (String pronounTag : pronounTags) {
                String[] forms;
                String enclisisTag = posTag + ":" + pronounTag;
                for (String form : forms = this.getSynthesizer().synthesize(at, enclisisTag)) {
                    if (isTitleCase) {
                        form = StringTools.uppercaseFirstChar((String)form);
                    } else if (isAllCaps) {
                        form = form.toUpperCase();
                    }
                    suggestions.add(form);
                }
            }
        }
        return new ArrayList<String>(suggestions);
    }

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int verbPos = Integer.parseInt(arguments.get("verbPos"));
        int pronounPos = Integer.parseInt(arguments.get("pronounPos"));
        boolean convertToAccusative = Boolean.parseBoolean(arguments.get("convertToAccusative"));
        AnalyzedTokenReadings pronounTokenReadings = patternTokens[pronounPos];
        AnalyzedTokenReadings verbStemTokenReadings = patternTokens[verbPos];
        List<String> pronounTags = this.getPronounTags(pronounTokenReadings, verbStemTokenReadings.getToken(), convertToAccusative);
        if (pronounTags.isEmpty()) {
            return null;
        }
        match.setSuggestedReplacements(this.getVerbForms(verbStemTokenReadings, pronounTags));
        return match;
    }
}

