/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;

public class PortugueseProclisisFilter
extends RuleFilter {
    protected PortugueseSynthesizer getSynthesizer() {
        return PortugueseSynthesizer.INSTANCE;
    }

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        AnalyzedTokenReadings encliticVerbTokenReadings = patternTokens[patternTokens.length - 1];
        HashSet suggestions = new HashSet(Collections.emptyList());
        for (AnalyzedToken at : encliticVerbTokenReadings.getReadings()) {
            String posTag = at.getPOSTag();
            if (posTag == null || !posTag.startsWith("V") || !posTag.contains(":")) continue;
            String oldToken = at.getToken();
            String[] tagParts = posTag.split(":");
            String verbTag = tagParts[0];
            String newVerb = this.getSynthesizer().synthesize(at, verbTag)[0];
            String[] oldTokenParts = oldToken.split("-");
            String oldVerb = oldTokenParts[0];
            String oldPronoun = oldTokenParts[1];
            ArrayList newPronounForms = new ArrayList(Collections.emptyList());
            switch (oldPronoun) {
                case "lo": 
                case "no": {
                    newPronounForms.add("o");
                    break;
                }
                case "la": 
                case "na": {
                    newPronounForms.add("a");
                    break;
                }
                case "los": {
                    newPronounForms.add("os");
                    break;
                }
                case "las": 
                case "nas": {
                    newPronounForms.add("as");
                    break;
                }
                case "nos": {
                    newPronounForms.add("nos");
                    if (!oldVerb.endsWith("m") && !oldVerb.endsWith("\u00e3o") && !oldVerb.endsWith("\u00f5e")) break;
                    newPronounForms.add("os");
                    break;
                }
                default: {
                    newPronounForms.add(oldPronoun);
                }
            }
            for (String newPronoun : newPronounForms) {
                String suggestion = newPronoun + " " + newVerb;
                suggestions.add(suggestion);
            }
        }
        match.setSuggestedReplacements(new ArrayList(suggestions));
        return match;
    }
}

