/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ru.MorfologikRussianSpellerRule;
import org.languagetool.rules.ru.RussianCompoundRule;
import org.languagetool.rules.ru.RussianConfusionProbabilityRule;
import org.languagetool.rules.ru.RussianDashRule;
import org.languagetool.rules.ru.RussianSimpleReplaceRule;
import org.languagetool.rules.ru.RussianUnpairedBracketsRule;
import org.languagetool.rules.ru.RussianVerbConjugationRule;
import org.languagetool.rules.ru.RussianWordCoherencyRule;
import org.languagetool.rules.ru.RussianWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ru.RussianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ru.RussianHybridDisambiguator;
import org.languagetool.tagging.ru.RussianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Russian
extends Language
implements AutoCloseable {
    private Tagger tagger;
    private Disambiguator disambiguator;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private LuceneLanguageModel languageModel;

    public Pattern getIgnoredCharactersRegex() {
        return Pattern.compile("[\u00ad\u0301\u0300]");
    }

    public String getName() {
        return "Russian";
    }

    public String getShortCode() {
        return "ru";
    }

    public String[] getCountries() {
        return new String[]{"RU"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new RussianTagger();
        }
        return this.tagger;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new RussianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new RussianSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Yakov Reztsov", "http://myooo.ru/content/view/83/43/")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"\u041d\u0435 \u0440\u043e\u0434<marker> ,</marker> \u0430 \u0443\u043c \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u044e \u0432 \u0432\u043e\u0435\u0432\u043e\u0434\u044b."), Example.fixed((String)"\u041d\u0435 \u0440\u043e\u0434<marker>,</marker> \u0430 \u0443\u043c \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u044e \u0432 \u0432\u043e\u0435\u0432\u043e\u0434\u044b.")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u043e\u0441\u044c \u043b\u0435\u0442\u043e. <marker>\u0434\u0435\u0442\u0438</marker> \u0441\u043d\u043e\u0432\u0430 \u0441\u0435\u043b\u0438 \u0437\u0430 \u0448\u043a\u043e\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0442\u044b."), Example.fixed((String)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u043e\u0441\u044c \u043b\u0435\u0442\u043e. <marker>\u0414\u0435\u0442\u0438</marker> \u0441\u043d\u043e\u0432\u0430 \u0441\u0435\u043b\u0438 \u0437\u0430 \u0448\u043a\u043e\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0442\u044b.")), new MorfologikRussianSpellerRule(messages, this, userConfig), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new RussianUnpairedBracketsRule(messages, this), new RussianCompoundRule(messages), new RussianSimpleReplaceRule(messages), new RussianWordCoherencyRule(messages), new RussianWordRepeatRule(messages), new RussianVerbConjugationRule(messages), new RussianDashRule()});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new RussianConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

