/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Russian;
import org.languagetool.rules.PartialPosTagFilter;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;

public class RussianPartialPosTagFilter
extends PartialPosTagFilter {
    private final Tagger tagger = new Russian().getTagger();
    private final Disambiguator disambiguator = new Russian().getDisambiguator();

    protected List<AnalyzedTokenReadings> tag(String token) {
        try {
            List tags = this.tagger.tag(Collections.singletonList(token));
            AnalyzedTokenReadings[] atr = tags.toArray(new AnalyzedTokenReadings[tags.size()]);
            AnalyzedSentence disambiguated = this.disambiguator.disambiguate(new AnalyzedSentence(atr));
            return Arrays.asList(disambiguated.getTokens());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag and disambiguate '" + token + "'", e);
        }
    }
}

