/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;

public class RussianUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> RU_START_SYMBOLS = Arrays.asList("(", "{", "\u201e", "\"", "'");
    private static final List<String> RU_END_SYMBOLS = Arrays.asList(")", "}", "\u201c", "\"", "'");
    private static final Pattern NUMERALS_RU = Pattern.compile("(?i)\\d{1,2}?[\u0430-\u044f]*|[\u0430-\u044f]|[\u0410-\u042f]|[\u0430-\u044f][\u0430-\u044f]|[\u0410-\u042f][\u0410-\u042f]|(?i)\\d{1,2}?[a-z']*|M*(D?C{0,3}|C[DM])(L?X{0,3}|X[LC])(V?I{0,3}|I[VX])$");

    public RussianUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, RU_START_SYMBOLS, RU_END_SYMBOLS, NUMERALS_RU);
        this.addExamplePair(Example.wrong((String)"\u0421\u0430\u043c\u043e\u043e\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u0441\u0442\u0443\u043f\u043e\u043a \u041e\u043b\u0435\u043d\u0438\u043d\u0430 <marker>(</marker>\u043f\u043e\u0434\u0430\u0440\u043e\u043a \u041b\u0443\u043a\u0430\u0448\u043a\u0435 \u043a\u043e\u043d\u044f \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043b\u0438\u0448\u044c \u0443\u0434\u0438\u0432\u043b\u0435\u043d\u0438\u0435 \u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0435\u0442 \u043d\u0435\u0434\u043e\u0432\u0435\u0440\u0438\u0435 \u043a \u043d\u0435\u043c\u0443 \u0441\u0442\u0430\u043d\u0438\u0447\u043d\u0438\u043a\u043e\u0432."), Example.fixed((String)"\u0421\u0430\u043c\u043e\u043e\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u0441\u0442\u0443\u043f\u043e\u043a \u041e\u043b\u0435\u043d\u0438\u043d\u0430 <marker>(</marker>\u043f\u043e\u0434\u0430\u0440\u043e\u043a \u041b\u0443\u043a\u0430\u0448\u043a\u0435 \u043a\u043e\u043d\u044f) \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043b\u0438\u0448\u044c \u0443\u0434\u0438\u0432\u043b\u0435\u043d\u0438\u0435 \u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0435\u0442 \u043d\u0435\u0434\u043e\u0432\u0435\u0440\u0438\u0435 \u043a \u043d\u0435\u043c\u0443 \u0441\u0442\u0430\u043d\u0438\u0447\u043d\u0438\u043a\u043e\u0432."));
    }

    public String getId() {
        return "RU_UNPAIRED_BRACKETS";
    }
}

