/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.LanguageWithModel;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.RussianChunker;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.ru.MorfologikRussianSpellerRule;
import org.languagetool.rules.ru.MorfologikRussianYOSpellerRule;
import org.languagetool.rules.ru.RussianCompoundRule;
import org.languagetool.rules.ru.RussianConfusionProbabilityRule;
import org.languagetool.rules.ru.RussianDashRule;
import org.languagetool.rules.ru.RussianFillerWordsRule;
import org.languagetool.rules.ru.RussianSimpleReplaceRule;
import org.languagetool.rules.ru.RussianSimpleWordRepeatRule;
import org.languagetool.rules.ru.RussianSpecificCaseRule;
import org.languagetool.rules.ru.RussianUnpairedBracketsRule;
import org.languagetool.rules.ru.RussianVerbConjugationRule;
import org.languagetool.rules.ru.RussianWordCoherencyRule;
import org.languagetool.rules.ru.RussianWordRepeatRule;
import org.languagetool.rules.ru.RussianWordRootRepeatRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ru.RussianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ru.RussianHybridDisambiguator;
import org.languagetool.tagging.ru.RussianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ru.RussianWordTokenizer;

public class Russian
extends LanguageWithModel {
    private static final String LANGUAGE_SHORT_CODE = "ru";
    private static volatile Throwable instantiationTrace;

    public Russian() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected Russian(boolean fakeValue) {
    }

    public Pattern getIgnoredCharactersRegex() {
        return Pattern.compile("[\u00ad\u0301\u0300]");
    }

    public String getName() {
        return "Russian";
    }

    public String getShortCode() {
        return LANGUAGE_SHORT_CODE;
    }

    public String[] getCountries() {
        return new String[]{"RU"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return RussianTagger.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return RussianHybridDisambiguator.getInstance();
    }

    @Nullable
    public Chunker createDefaultPostDisambiguationChunker() {
        return new RussianChunker();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return RussianSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new RussianWordTokenizer();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Yakov Reztsov", "http://myooo.ru/content/view/83/43/")};
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"\u041d\u0435 \u0440\u043e\u0434<marker> ,</marker> \u0430 \u0443\u043c \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u044e \u0432 \u0432\u043e\u0435\u0432\u043e\u0434\u044b."), Example.fixed((String)"\u041d\u0435 \u0440\u043e\u0434<marker>,</marker> \u0430 \u0443\u043c \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u044e \u0432 \u0432\u043e\u0435\u0432\u043e\u0434\u044b.")), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u043e\u0441\u044c \u043b\u0435\u0442\u043e. <marker>\u0434\u0435\u0442\u0438</marker> \u0441\u043d\u043e\u0432\u0430 \u0441\u0435\u043b\u0438 \u0437\u0430 \u0448\u043a\u043e\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0442\u044b."), Example.fixed((String)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u043e\u0441\u044c \u043b\u0435\u0442\u043e. <marker>\u0414\u0435\u0442\u0438</marker> \u0441\u043d\u043e\u0432\u0430 \u0441\u0435\u043b\u0438 \u0437\u0430 \u0448\u043a\u043e\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0442\u044b.")), new MorfologikRussianSpellerRule(messages, (Language)this, userConfig, altLanguages), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new ParagraphRepeatBeginningRule(messages, (Language)this), new RussianFillerWordsRule(messages, (Language)this, userConfig), new PunctuationMarkAtParagraphEnd2(messages, (Language)this), new MorfologikRussianYOSpellerRule(messages, (Language)this, userConfig, altLanguages), new RussianUnpairedBracketsRule(messages, (Language)this), new RussianCompoundRule(messages, (Language)this, userConfig), new RussianSimpleReplaceRule(messages), new RussianSimpleWordRepeatRule(messages, (Language)this), new RussianWordCoherencyRule(messages), new RussianWordRepeatRule(messages), new RussianWordRootRepeatRule(messages), new RussianVerbConjugationRule(messages), new RussianDashRule(messages), new RussianSpecificCaseRule(messages)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return List.of(new RussianConfusionProbabilityRule(messages, languageModel, (Language)this));
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "RU_DASH_RULE": {
                return 12;
            }
            case "RU_COMPOUNDS": {
                return 11;
            }
            case "RUSSIAN_SIMPLE_REPLACE_RULE": {
                return 10;
            }
            case "RUSSIAN_SPECIFIC_CASE": {
                return 9;
            }
            case "MORFOLOGIC_RULE_RU_RU_YO": {
                return 2;
            }
            case "MORFOLOGIC_RULE_RU_RU": {
                return 1;
            }
            case "Word_root_repeat": {
                return -1;
            }
            case "PUNCT_DPT_2": {
                return -2;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
        }
        return super.getPriorityForId(id);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikRussianSpellerRule(messages, (Language)this, null, null);
    }

    @NotNull
    public static Russian getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Russian) {
            Russian russian = (Russian)language;
            return russian;
        }
        throw new RuntimeException("Russian language expected, got " + language);
    }
}

