/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.WordRepeatRule;

public class RussianSimpleWordRepeatRule
extends WordRepeatRule {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z\u0430-\u044f\u0451\u0410-\u042f\u0401]");

    public RussianSimpleWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (this.wordRepetitionOf("-", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u0438", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("\u043f\u043e", tokens, position)) {
            return true;
        }
        if (tokens[position - 1].getToken().equals("\u041f\u041e") && tokens[position].getToken().equals("\u043f\u043e")) {
            return true;
        }
        if (tokens[position - 1].getToken().equals("\u043f\u043e") && tokens[position].getToken().equals("\u041f\u041e")) {
            return true;
        }
        if (this.wordRepetitionOf("\u0447\u0442\u043e", tokens, position)) {
            return true;
        }
        if (PATTERN.matcher(tokens[position].getToken()).matches() && position > 1 && PATTERN.matcher(tokens[position - 1].getToken()).matches()) {
            return true;
        }
        return super.ignore(tokens, position);
    }
}

