/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tagging.BaseTagger;

public class RussianTagger
extends BaseTagger {
    public static final RussianTagger INSTANCE = new RussianTagger();

    public RussianTagger() {
        super("/ru/russian.dict", new Locale("ru"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            boolean mayMissingYo = false;
            if (word.length() > 1) {
                if (!(word.contains("\u0451") || word.contains("\u0401") || !word.contains("\u0435") && !word.contains("\u0415") || word.contains("\u0435\u0301") || word.contains("\u043e\u0301") || word.contains("\u0430\u0301") || word.contains("\u0443\u0301") || word.contains("\u0438\u0301") || word.contains("\u044e\u0301") || word.contains("\u044b\u0301") || word.contains("\u044d\u0301") || word.contains("\u044f\u0301"))) {
                    mayMissingYo = true;
                }
                word = word.replace("\u043e\u0301", "\u043e");
                word = word.replace("\u0430\u0301", "\u0430");
                word = word.replace("\u0435\u0301", "\u0435");
                word = word.replace("\u0443\u0301", "\u0443");
                word = word.replace("\u0438\u0301", "\u0438");
                word = word.replace("\u044b\u0301", "\u044b");
                word = word.replace("\u044d\u0301", "\u044d");
                word = word.replace("\u044e\u0301", "\u044e");
                word = word.replace("\u044f\u0301", "\u044f");
                word = word.replace("\u043e\u0300", "\u043e");
                word = word.replace("\u0430\u0300", "\u0430");
                word = word.replace("\u0435\u0300", "\u0435");
                word = word.replace("\u0443\u0300", "\u0443");
                word = word.replace("\u045d", "\u0438");
                word = word.replace("\u044b\u0300", "\u044b");
                word = word.replace("\u044d\u0300", "\u044d");
                word = word.replace("\u044e\u0300", "\u044e");
                word = word.replace("\u044f\u0300", "\u044f");
                word = word.replace("\u02bc", "\u044a");
            }
            List l = this.getAnalyzedTokens(word);
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (mayMissingYo) {
                String wordLc = word.toLowerCase().replace("\u0435", "\u0451");
                if (this.getWordTagger().tag(wordLc).isEmpty()) {
                    mayMissingYo = false;
                }
            }
            if (mayMissingYo) {
                ArrayList<ChunkTag> listChunkTags = new ArrayList<ChunkTag>();
                listChunkTags.add(new ChunkTag("MayMissingYO"));
                atr.setChunkTags(listChunkTags);
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }
}

