/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.sk.CompoundRule;
import org.languagetool.rules.sk.MorfologikSlovakSpellerRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.sk.SlovakSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.sk.SlovakTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Slovak
extends Language {
    private static final List<String> RULE_FILES = Arrays.asList("grammar-typography.xml");

    public String getName() {
        return "Slovak";
    }

    public String getShortCode() {
        return "sk";
    }

    public String[] getCountries() {
        return new String[]{"SK"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new SlovakTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new SlovakSynthesizer(this);
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Zdenko Podobn\u00fd", "http://sk-spell.sk.cx")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u00bb", "\u00ab", "\""), Arrays.asList("]", ")", "}", "\u201c", "\u00ab", "\u00bb", "\"")), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new CompoundRule(messages, this, userConfig), new MorfologikSlovakSpellerRule(messages, this, userConfig, altLanguages)});
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dirBase = dataBroker.getRulesDir() + "/" + this.getShortCode() + "/";
        for (String ruleFile : RULE_FILES) {
            ruleFileNames.add(dirBase + ruleFile);
        }
        return ruleFileNames;
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikSlovakSpellerRule(messages, this, null, null);
    }
}

