/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.IPOSTag;

public class UkrainianTagger
extends BaseTagger {
    private static final String VERB_TAG_FOR_REV_IMPR = IPOSTag.verb.getText() + ":rev:impr";
    private static final String VERB_TAG_FOR_IMPR = IPOSTag.verb.getText() + ":impr";
    private static final String ADJ_TAG_FOR_PO_ADV_MIS = IPOSTag.adj.getText() + ":m:v_mis";
    private static final String ADJ_TAG_FOR_PO_ADV_NAZ = IPOSTag.adj.getText() + ":m:v_naz";
    private static final Pattern NUMBER = Pattern.compile("[+-]?[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?(%|\u00b0\u0421?)?");
    private static final String stdNounTag = IPOSTag.noun.getText() + ":.:v_";
    private static final int stdNounTagLen = stdNounTag.length();
    private static final Pattern stdNounTagRegex = Pattern.compile(stdNounTag + ".*");
    private static final Pattern stdNounNvTagRegex = Pattern.compile(IPOSTag.noun.getText() + ":.:nv");
    private static final Set<String> dashPrefixes = new HashSet<String>(Arrays.asList("\u0432\u0456\u0446\u0435", "\u0435\u043a\u0441", "\u043b\u0435\u0439\u0431", "\u043c\u0430\u043a\u0441\u0456", "\u043c\u0456\u0434\u0456", "\u043c\u0456\u043d\u0456", "\u043e\u0431\u0435\u0440", "\u0433\u043e\u0440\u0435", "\u043c\u0435\u0434\u0456\u0430", "\u0431\u0456\u0437\u043d\u0435\u0441", "\u0456\u043d\u0442\u0435\u0440\u043d\u0435\u0442", "\u0431\u043b\u043e\u043a", "\u0430\u0440\u0442", "\u0456\u0441\u0442\u043e\u0440\u0438\u043a\u043e", "\u0433\u0430\u043c\u043c\u0430", "\u0432\u0430\u043a\u0443\u0443\u043c", "\u0433\u0435\u043d\u0435\u0440\u0430\u043b", "\u0441\u0435\u043a\u0441", "\u0440\u043e\u043a", "\u043f\u0440\u0435\u0441", "\u043d\u0430\u0446\u0456\u043e\u043d\u0430\u043b", "\u0441\u043e\u0446\u0456\u0430\u043b", "\u0434\u0438\u0437\u0435\u043b\u044c", "\u0444\u0430\u043d", "\u0435\u043a\u0441\u043f\u0440\u0435\u0441", "\u0434\u0435\u043b\u044c\u0442\u0430", "\u0442\u043e\u043f", "\u0444\u043b\u0435\u0448", "\u0442\u043e\u043f", "\u043f\u0456\u0430\u0440", "\u0434\u0436\u0430\u0437", "\u0433\u0435\u0439", "\u0430\u0444\u043b\u044c\u0444\u0430", "\u0448\u0442\u0430\u0431", "\u0447\u0443\u0434\u043e", "\u0446\u0430\u0440", "\u043f\u0440\u0435\u043c'\u0454\u0440", "\u0412\u0406\u041b", "\u043a\u0440\u043e\u0441", "\u0432\u0435\u0431", "\u0433\u0440\u0430\u043d\u0434", "\u0435\u043a\u043e\u043d\u043e\u043c", "\u0431\u0435\u0442\u0430", "\u0431\u0430\u0441", "\u043f\u043e\u043f", "\u0445\u0435\u0448", "\u0444\u0456\u0442\u043d\u0435\u0441", "\u0441\u043f\u0430\u043c", "\u0441\u0430\u043b\u043e\u043d", "\u0440\u0438\u0442\u043c", "\u0440\u0435\u043d\u0442\u0433\u0435\u043d", "\u043a\u043e\u043d\u0444\u0435\u0440\u0435\u043d\u0446", "\u043a\u043e\u043d\u0442\u0435\u043d\u0442", "\u043a\u0456\u0431\u0435\u0440", "\u0434\u0438\u0437\u0430\u0439\u043d", "\u0431\u0430\u0439\u043a\u0435\u0440", "\u0444\u043e\u043b\u043a", "\u0442\u043e\u0440\u0435\u043d\u0442", "\u0441\u043f\u0430\u0440\u0438\u043d\u0433", "\u0441\u043c\u0430\u0440\u0442", "\u043f\u0430\u043d\u043a", "\u043e\u0444\u0456\u0441", "\u043e\u043d\u043b\u0430\u0439\u043d", "\u043b\u044e\u043a\u0441", "\u043a\u043e\u043d\u0446\u0435\u043f\u0442", "\u0434\u043e\u043f\u0456\u043d\u0433", "\u0431\u043b\u044e\u0437"));
    private static final Set<String> cityAvenue = new HashSet<String>(Arrays.asList("\u0441\u0456\u0442\u0456", "\u0430\u0432\u0435\u043d\u044e", "\u0441\u0442\u0440\u0456\u0442", "\u0448\u0442\u0440\u0430\u0441\u0441\u0435"));
    public static final Map<String, String> VIDMINKY_MAP;

    public final String getFileName() {
        return "/uk/ukrainian.dict";
    }

    public String getManualAdditionsFileName() {
        return "/uk/added.txt";
    }

    public UkrainianTagger() {
        this.setLocale(new Locale("uk", "UA"));
        this.dontTagLowercaseWithUppercase();
    }

    public List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.number.getText(), word));
            return additionalTaggedTokens;
        }
        if (word.contains("-")) {
            List leftAnalyzedTokens;
            List<AnalyzedToken> tagMatch;
            List wdList;
            int dashIdx = word.lastIndexOf(45);
            if (dashIdx == 0 || dashIdx == word.length() - 1) {
                return null;
            }
            int firstDashIdx = word.indexOf(45);
            if (dashIdx != firstDashIdx) {
                return null;
            }
            String leftWord = word.substring(0, dashIdx);
            String rightWord = word.substring(dashIdx + 1);
            if (rightWord.equals("\u043d\u043e") || rightWord.equals("\u0431\u043e")) {
                List leftWdList = wordTagger.tag(leftWord);
                if (leftWdList.isEmpty()) {
                    return null;
                }
                List leftAnalyzedTokens2 = this.asAnalyzedTokenListForTaggedWords(leftWord, leftWdList);
                return this.verbImperNoBo(word, leftAnalyzedTokens2);
            }
            if (leftWord.equalsIgnoreCase("\u043f\u043e") && rightWord.endsWith("\u0441\u044c\u043a\u0438")) {
                rightWord = rightWord + "\u0439";
            }
            if ((wdList = wordTagger.tag(rightWord)).isEmpty()) {
                return null;
            }
            List rightAnalyzedTokens = this.asAnalyzedTokenListForTaggedWords(rightWord, wdList);
            if (leftWord.equalsIgnoreCase("\u043f\u043e")) {
                if (rightWord.endsWith("\u043e\u043c\u0443")) {
                    return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_MIS);
                }
                if (rightWord.endsWith("\u0441\u044c\u043a\u0438\u0439")) {
                    return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_NAZ);
                }
                return null;
            }
            if (dashPrefixes.contains(leftWord.toLowerCase())) {
                return this.eksNounMatch(word, rightAnalyzedTokens, leftWord);
            }
            if (Character.isUpperCase(leftWord.charAt(0)) && cityAvenue.contains(rightWord)) {
                List leftWdList = wordTagger.tag(leftWord);
                if (leftWdList.isEmpty()) {
                    return null;
                }
                List leftAnalyzedTokens3 = this.asAnalyzedTokenListForTaggedWords(leftWord, leftWdList);
                return this.cityAvenueMatch(word, leftAnalyzedTokens3);
            }
            List leftWdList = wordTagger.tag(leftWord);
            if (!leftWdList.isEmpty() && (tagMatch = this.tagMatch(word, leftAnalyzedTokens = this.asAnalyzedTokenListForTaggedWords(leftWord, leftWdList), rightAnalyzedTokens)) != null) {
                return tagMatch;
            }
            if (leftWord.endsWith("\u043e")) {
                return this.oAdjMatch(word, rightAnalyzedTokens, leftWord);
            }
        }
        return null;
    }

    private List<AnalyzedToken> cityAvenueMatch(String word, List<AnalyzedToken> leftAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.matches(IPOSTag.noun.getText() + ":.:v_naz.*")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag.replaceFirst("v_naz", "nv"), word));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private List<AnalyzedToken> verbImperNoBo(String word, List<AnalyzedToken> leftAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(VERB_TAG_FOR_IMPR) && !posTag.startsWith(VERB_TAG_FOR_REV_IMPR)) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private List<AnalyzedToken> tagMatch(String word, List<AnalyzedToken> leftAnalyzedTokens, List<AnalyzedToken> rightAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken leftAnalyzedToken : leftAnalyzedTokens) {
            String leftPosTag = leftAnalyzedToken.getPOSTag();
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (leftPosTag == null || rightPosTag == null) continue;
                if (leftPosTag.equals(rightPosTag) && (leftPosTag.startsWith(IPOSTag.numr.getText()) || leftPosTag.startsWith(IPOSTag.adv.getText()) || leftPosTag.startsWith(IPOSTag.adj.getText()))) {
                    newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (!leftPosTag.startsWith(IPOSTag.noun.getText()) || !rightPosTag.startsWith(IPOSTag.noun.getText())) continue;
                String agreedPosTag = this.getArgreedPosTag(leftPosTag, rightPosTag);
                if (agreedPosTag == null && rightPosTag.startsWith(IPOSTag.noun.getText() + ":m:v_naz") && (rightAnalyzedToken.getToken().equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c") || rightAnalyzedToken.getToken().equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c"))) {
                    agreedPosTag = leftPosTag;
                }
                if (agreedPosTag == null) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
            }
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private String getArgreedPosTag(String leftPosTag, String rightPosTag) {
        if (UkrainianTagger.isPlural(leftPosTag) && !UkrainianTagger.isPlural(rightPosTag)) {
            return null;
        }
        if (!UkrainianTagger.istotaNeistotaMatch(leftPosTag, rightPosTag)) {
            return null;
        }
        if (stdNounTagRegex.matcher(leftPosTag).matches()) {
            String substring2;
            String substring1;
            if (stdNounTagRegex.matcher(rightPosTag).matches() ? (substring1 = leftPosTag.substring(stdNounTagLen, stdNounTagLen + 3)).equals(substring2 = rightPosTag.substring(stdNounTagLen, stdNounTagLen + 3)) : stdNounNvTagRegex.matcher(rightPosTag).matches()) {
                return leftPosTag;
            }
        } else if (stdNounNvTagRegex.matcher(leftPosTag).matches() && stdNounTagRegex.matcher(rightPosTag).matches()) {
            return rightPosTag;
        }
        return null;
    }

    private static boolean istotaNeistota(String leftPosTag, String rightPosTag) {
        return leftPosTag.contains(":ist") && !rightPosTag.contains(":ist");
    }

    private static boolean istotaNeistotaMatch(String leftPosTag, String rightPosTag) {
        return leftPosTag.contains(":ist") && rightPosTag.contains(":ist") || !leftPosTag.contains(":ist") && !rightPosTag.contains(":ist");
    }

    private static boolean istotaNeistotaNazZna(String leftPosTag, String rightPosTag) {
        return UkrainianTagger.istotaNeistota(leftPosTag, rightPosTag) && (UkrainianTagger.isPlural(leftPosTag) && UkrainianTagger.isPlural(rightPosTag) || rightPosTag.contains(":m:") || rightPosTag.contains(":n:")) && leftPosTag.contains(":v_naz") && rightPosTag.contains(":v_zna");
    }

    private static boolean isPlural(String posTag) {
        return posTag.startsWith(IPOSTag.noun.getText() + ":p:");
    }

    private List<AnalyzedToken> oAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private List<AnalyzedToken> eksNounMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.noun.getText())) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private List<AnalyzedToken> poAdvMatch(String word, List<AnalyzedToken> analyzedTokens, String adjTag) {
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(adjTag)) continue;
            return Arrays.asList(new AnalyzedToken(word, IPOSTag.adv.getText(), word));
        }
        return null;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("v_naz", "\u043d\u0430\u0437\u0438\u0432\u043d\u0438\u0439");
        map.put("v_rod", "\u0440\u043e\u0434\u043e\u0432\u0438\u0439");
        map.put("v_dav", "\u0434\u0430\u0432\u0430\u043b\u044c\u043d\u0438\u0439");
        map.put("v_zna", "\u0437\u043d\u0430\u0445\u0456\u0434\u043d\u0438\u0439");
        map.put("v_oru", "\u043e\u0440\u0443\u0434\u043d\u0438\u0439");
        map.put("v_mis", "\u043c\u0456\u0441\u0446\u0435\u0432\u0438\u0439");
        map.put("v_kly", "\u043a\u043b\u0438\u0447\u043d\u0438\u0439");
        VIDMINKY_MAP = Collections.unmodifiableMap(map);
    }
}

