/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class HiddenCharacterRule
extends Rule {
    private static final Character HIDDEN_CHAR = Character.valueOf('\u00ad');

    public HiddenCharacterRule(ResourceBundle messages) throws IOException {
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    public final String getId() {
        return "UK_HIDDEN_CHARS";
    }

    public String getDescription() {
        return "\u041f\u0440\u0438\u0445\u043e\u0432\u0430\u043d\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438: \u0437\u043d\u0430\u043a \u043c\u2019\u044f\u043a\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u043d\u044f";
    }

    public String getShort() {
        return "\u041f\u0440\u0438\u0445\u043e\u0432\u0430\u043d\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438";
    }

    public String getSuggestion(String word) {
        String highlighted = word.replace(HIDDEN_CHAR.charValue(), '-');
        return " \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u0438\u0439 \u0437\u043d\u0430\u043a \u043c\u2019\u044f\u043a\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u043d\u044f: \u00ab" + highlighted + "\u00bb, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: ";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            String tokenString = tokenReadings.getToken();
            if (tokenString.indexOf(HIDDEN_CHAR.charValue()) == -1) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings) {
        String tokenString = tokenReadings.getToken();
        String replacement = tokenString.replace(HIDDEN_CHAR.toString(), "");
        String msg = tokenString + this.getSuggestion(tokenString) + replacement;
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + tokenString.length(), msg, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(Arrays.asList(replacement));
        return potentialRuleMatch;
    }

    public void reset() {
    }
}

