/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundTagger;
import org.languagetool.tagging.uk.IPOSTag;

public class UkrainianTagger
extends BaseTagger {
    static final Pattern NUMBER = Pattern.compile("[+-\u00b1]?[\u20ac\u20b4\\$]?[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?(%|\u00b0\u0421?)?|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final Pattern DATE = Pattern.compile("[\\d]{2}\\.[\\d]{2}\\.[\\d]{4}");
    private static final Pattern TIME = Pattern.compile("([01]?[0-9]|2[0-3])[.:][0-5][0-9]");
    private final CompoundTagger compoundTagger;

    public String getManualAdditionsFileName() {
        return "/uk/added.txt";
    }

    public UkrainianTagger() {
        super("/uk/ukrainian.dict", new Locale("uk", "UA"), false);
        this.compoundTagger = new CompoundTagger(this, this.wordTagger, this.conversionLocale);
    }

    public List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.number.getText(), word));
            return additionalTaggedTokens;
        }
        if (TIME.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.time.getText(), word));
            return additionalTaggedTokens;
        }
        if (DATE.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.date.getText(), word));
            return additionalTaggedTokens;
        }
        if (word.contains("-")) {
            List<AnalyzedToken> guessedCompoundTags = this.compoundTagger.guessCompoundTag(word);
            return guessedCompoundTags;
        }
        return null;
    }

    protected List<AnalyzedToken> getAnalyzedTokens(String word) {
        List tokens = super.getAnalyzedTokens(word);
        if (((AnalyzedToken)tokens.get(0)).getPOSTag() == null && word.indexOf(8211) != -1 && word.matches(".*[\u0430-\u044f\u0456\u0457\u0454\u0491][\u2013][\u0430-\u044f\u0456\u0457\u0454\u0491].*")) {
            String newWord = word.replace('\u2013', '-');
            List newTokens = super.getAnalyzedTokens(newWord);
            for (int i = 0; i < newTokens.size(); ++i) {
                AnalyzedToken analyzedToken = (AnalyzedToken)newTokens.get(i);
                if (!newWord.equals(analyzedToken.getToken())) continue;
                String lemma = analyzedToken.getLemma();
                if (lemma != null) {
                    lemma = lemma.replace('-', '\u2013');
                }
                AnalyzedToken newToken = new AnalyzedToken(word, analyzedToken.getPOSTag(), lemma);
                newTokens.set(i, newToken);
            }
            tokens = newTokens;
        }
        return tokens;
    }

    List<AnalyzedToken> asAnalyzedTokenListForTaggedWordsInternal(String word, List<TaggedWord> taggedWords) {
        return super.asAnalyzedTokenListForTaggedWords(word, taggedWords);
    }
}

