/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tagging.uk.UkrainianTagger;

class CompoundTagger {
    private static final String DEBUG_COMPOUNDS_PROPERTY = "org.languagetool.tagging.uk.UkrainianTagger.debugCompounds";
    private static final String TAG_ANIM = ":anim";
    private static final String NV_TAG = ":nv";
    private static final String COMPB_TAG = ":compb";
    private static final Pattern EXTRA_TAGS = Pattern.compile("(:(v-u|np|ns|bad|slang|rare))+");
    private static final Pattern NOUN_SING_V_ROD_REGEX = Pattern.compile("noun:[mfn]:v_rod.*");
    private static final Pattern NOUN_V_NAZ_REGEX = Pattern.compile("noun:.:v_naz.*");
    private static final Pattern SING_REGEX_F = Pattern.compile(":[mfn]:");
    private static final Pattern O_ADJ_PATTERN = Pattern.compile(".*(\u043e|[\u0447\u0448\u0449]\u0435)");
    private static final Pattern DASH_PREFIX_LAT_PATTERN = Pattern.compile("[a-zA-Z]{3,}");
    private static final Pattern MNP_NAZ_REGEX = Pattern.compile(".*:[mnp]:v_naz.*");
    private static final Pattern MNP_ZNA_REGEX = Pattern.compile(".*:[mnp]:v_zna.*");
    private static final Pattern MNP_ROD_REGEX = Pattern.compile(".*:[mnp]:v_rod.*");
    private static final String stdNounTag = IPOSTag.noun.getText() + ":.:v_";
    private static final int stdNounTagLen = stdNounTag.length();
    private static final Pattern stdNounTagRegex = Pattern.compile(stdNounTag + ".*");
    private static final Set<String> dashPrefixes;
    private static final Set<String> leftMasterSet;
    private static final Set<String> cityAvenue;
    private static final Map<String, Pattern> rightPartsWithLeftTagMap;
    private static final Set<String> slaveSet;
    private static final Map<String, List<String>> NUMR_ENDING_MAP;
    private static final String ADJ_TAG_FOR_PO_ADV_MIS;
    private static final String ADJ_TAG_FOR_PO_ADV_NAZ;
    private static final List<String> LEFT_O_ADJ;
    private final WordTagger wordTagger;
    private final Locale conversionLocale;
    private final UkrainianTagger ukrainianTagger;
    private BufferedWriter compoundUnknownDebugWriter;
    private BufferedWriter compoundTaggedDebugWriter;

    CompoundTagger(UkrainianTagger ukrainianTagger, WordTagger wordTagger, Locale conversionLocale) {
        this.ukrainianTagger = ukrainianTagger;
        this.wordTagger = wordTagger;
        this.conversionLocale = conversionLocale;
        if (Boolean.valueOf(System.getProperty(DEBUG_COMPOUNDS_PROPERTY)).booleanValue()) {
            this.debugCompounds();
        }
    }

    @Nullable
    public List<AnalyzedToken> guessCompoundTag(String word) {
        List<AnalyzedToken> guessedCompoundTags = this.doGuessCompoundTag(word);
        this.debug_compound_tagged_write(guessedCompoundTags);
        return guessedCompoundTags;
    }

    @Nullable
    private List<AnalyzedToken> doGuessCompoundTag(String word) {
        List<AnalyzedToken> leftAnalyzedTokens;
        List<AnalyzedToken> tagMatch;
        List rightWdList;
        int dashIdx = word.lastIndexOf(45);
        if (dashIdx == 0 || dashIdx == word.length() - 1) {
            return null;
        }
        int firstDashIdx = word.indexOf(45);
        if (dashIdx != firstDashIdx) {
            return null;
        }
        String leftWord = word.substring(0, dashIdx);
        String rightWord = word.substring(dashIdx + 1);
        List<TaggedWord> leftWdList = this.tagBothCases(leftWord);
        if (rightPartsWithLeftTagMap.containsKey(rightWord)) {
            if (leftWdList.isEmpty()) {
                return null;
            }
            Pattern leftTagRegex = rightPartsWithLeftTagMap.get(rightWord);
            List<AnalyzedToken> leftAnalyzedTokens2 = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens2.size());
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens2) {
                String posTag = analyzedToken.getPOSTag();
                if (posTag == null || !leftTagRegex.matcher(posTag).matches()) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, analyzedToken.getLemma()));
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        if (UkrainianTagger.NUMBER.matcher(leftWord).matches()) {
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            if (NUMR_ENDING_MAP.containsKey(rightWord)) {
                List<String> tags = NUMR_ENDING_MAP.get(rightWord);
                for (String tag : tags) {
                    newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.adj.getText() + tag, leftWord + "-" + "\u0439"));
                }
            } else {
                List rightWdList2 = this.wordTagger.tag(rightWord);
                if (rightWdList2.isEmpty()) {
                    return null;
                }
                List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList2);
                for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                    if (!analyzedToken.getPOSTag().startsWith(IPOSTag.adj.getText())) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + analyzedToken.getLemma()));
                }
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e") && rightWord.endsWith("\u0441\u044c\u043a\u0438")) {
            rightWord = rightWord + "\u0439";
        }
        if ((rightWdList = this.wordTagger.tag(rightWord)).isEmpty()) {
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList);
        if (leftWord.equalsIgnoreCase("\u043f\u043e")) {
            if (rightWord.endsWith("\u043e\u043c\u0443")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_MIS);
            }
            if (rightWord.endsWith("\u0441\u044c\u043a\u0438\u0439")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_NAZ);
            }
            return null;
        }
        if (dashPrefixes.contains(leftWord) || dashPrefixes.contains(leftWord.toLowerCase()) || DASH_PREFIX_LAT_PATTERN.matcher(leftWord).matches()) {
            return this.getNvPrefixNounMatch(word, rightAnalyzedTokens, leftWord);
        }
        if (word.startsWith("\u043f\u0456\u0432-") && Character.isUpperCase(word.charAt(4))) {
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (rightPosTag == null || !NOUN_SING_V_ROD_REGEX.matcher(rightPosTag).matches()) continue;
                for (String vid : PosTagHelper.VIDMINKY_MAP.keySet()) {
                    if (vid.equals("v_kly")) continue;
                    String posTag = rightPosTag.replace("v_rod", vid);
                    newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                }
            }
            return newAnalyzedTokens;
        }
        if (Character.isUpperCase(leftWord.charAt(0)) && cityAvenue.contains(rightWord)) {
            if (leftWdList.isEmpty()) {
                return null;
            }
            List<AnalyzedToken> leftAnalyzedTokens3 = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            return this.cityAvenueMatch(word, leftAnalyzedTokens3);
        }
        if (!leftWdList.isEmpty() && (tagMatch = this.tagMatch(word, leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList), rightAnalyzedTokens)) != null) {
            return tagMatch;
        }
        if (O_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.oAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        this.debug_compound_unknown_write(word);
        return null;
    }

    @Nullable
    private List<AnalyzedToken> cityAvenueMatch(String word, List<AnalyzedToken> leftAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!NOUN_V_NAZ_REGEX.matcher(posTag).matches()) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag.replaceFirst("v_naz", "nv"), word));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> tagMatch(String word, List<AnalyzedToken> leftAnalyzedTokens, List<AnalyzedToken> rightAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        ArrayList<AnalyzedToken> newAnalyzedTokensAnimInanim = new ArrayList<AnalyzedToken>();
        String animInanimNotTagged = null;
        for (AnalyzedToken leftAnalyzedToken : leftAnalyzedTokens) {
            Matcher matcher;
            String leftPosTag = leftAnalyzedToken.getPOSTag();
            if (leftPosTag == null) continue;
            String leftPosTagExtra = "";
            boolean leftNv = false;
            if (leftPosTag.contains(NV_TAG)) {
                leftNv = true;
                leftPosTag = leftPosTag.replace(NV_TAG, "");
            }
            if ((matcher = EXTRA_TAGS.matcher(leftPosTag)).find()) {
                leftPosTagExtra = leftPosTagExtra + matcher.group();
                leftPosTag = matcher.replaceAll("");
            }
            if (leftPosTag.contains(COMPB_TAG)) {
                leftPosTag = leftPosTag.replace(COMPB_TAG, "");
            }
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String leftGenderConj;
                String agreedPosTag;
                Matcher matcherR;
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (rightPosTag == null) continue;
                String extraNvTag = "";
                boolean rightNv = false;
                if (rightPosTag.contains(NV_TAG)) {
                    rightNv = true;
                    if (leftNv) {
                        extraNvTag = extraNvTag + NV_TAG;
                    }
                }
                if ((matcherR = EXTRA_TAGS.matcher(rightPosTag)).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if (rightPosTag.contains(COMPB_TAG)) {
                    rightPosTag = rightPosTag.replace(COMPB_TAG, "");
                }
                if (leftPosTag.equals(rightPosTag) && IPOSTag.startsWith(leftPosTag, IPOSTag.numr, IPOSTag.adv, IPOSTag.adj, IPOSTag.excl, IPOSTag.verb)) {
                    newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.noun.getText()) && rightPosTag.startsWith(IPOSTag.noun.getText())) {
                    agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag == null && rightPosTag.startsWith("noun:m:v_naz") && CompoundTagger.isMinMax(rightAnalyzedToken.getToken())) {
                        agreedPosTag = leftPosTag;
                    }
                    if (agreedPosTag == null && !CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
                        agreedPosTag = this.tryAnimInanim(leftPosTag, rightPosTag, leftAnalyzedToken.getLemma(), rightAnalyzedToken.getLemma(), leftNv, rightNv);
                        if (agreedPosTag == null) {
                            animInanimNotTagged = leftPosTag.contains(TAG_ANIM) ? "anim-inanim" : "inanim-anim";
                        } else {
                            newAnalyzedTokensAnimInanim.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                            continue;
                        }
                    }
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.numr.getText()) && rightPosTag.startsWith(IPOSTag.numr.getText())) {
                    agreedPosTag = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (IPOSTag.startsWith(leftPosTag, IPOSTag.noun) && IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) {
                    leftGenderConj = PosTagHelper.getGenderConj(leftPosTag);
                    if (leftGenderConj != null && leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        continue;
                    }
                    String agreedPosTag2 = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag2 == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2 + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (!leftPosTag.startsWith(IPOSTag.noun.getText()) || !IPOSTag.startsWith(rightPosTag, IPOSTag.adj, IPOSTag.numr) || (leftGenderConj = PosTagHelper.getGenderConj(leftPosTag)) == null || !leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
            }
        }
        if (newAnalyzedTokens.isEmpty()) {
            newAnalyzedTokens = newAnalyzedTokensAnimInanim;
        }
        if (animInanimNotTagged != null && newAnalyzedTokens.isEmpty()) {
            this.debug_compound_unknown_write(word + " " + animInanimNotTagged);
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private String getNumAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv) {
        String leftConj;
        String agreedPosTag = null;
        if ((leftPosTag.contains(":p:") && SING_REGEX_F.matcher(rightPosTag).find() || SING_REGEX_F.matcher(leftPosTag).find() && rightPosTag.contains(":p:")) && (leftConj = PosTagHelper.getConj(leftPosTag)) != null && leftConj.equals(PosTagHelper.getConj(rightPosTag))) {
            agreedPosTag = leftPosTag;
        }
        return agreedPosTag;
    }

    @Nullable
    private String getAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv) {
        String substring2;
        String substring1;
        if (CompoundTagger.isPlural(leftPosTag) && !CompoundTagger.isPlural(rightPosTag) || !CompoundTagger.isPlural(leftPosTag) && CompoundTagger.isPlural(rightPosTag)) {
            return null;
        }
        if (!CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
            return null;
        }
        if (stdNounTagRegex.matcher(leftPosTag).matches() && stdNounTagRegex.matcher(rightPosTag).matches() && (substring1 = leftPosTag.substring(stdNounTagLen, stdNounTagLen + 3)).equals(substring2 = rightPosTag.substring(stdNounTagLen, stdNounTagLen + 3))) {
            if (leftNv) {
                return rightPosTag;
            }
            return leftPosTag;
        }
        return null;
    }

    private static boolean isMinMax(String rightToken) {
        return rightToken.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c") || rightToken.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c");
    }

    @Nullable
    private String tryAnimInanim(String leftPosTag, String rightPosTag, String leftLemma, String rightLemma, boolean leftNv, boolean rightNv) {
        String agreedPosTag = null;
        if (leftMasterSet.contains(leftLemma)) {
            rightPosTag = leftPosTag.contains(TAG_ANIM) ? rightPosTag + TAG_ANIM : rightPosTag.replace(TAG_ANIM, "");
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv);
            if (agreedPosTag == null) {
                if (!leftPosTag.contains(TAG_ANIM)) {
                    if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                        agreedPosTag = leftPosTag;
                    }
                } else if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_ROD_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                    agreedPosTag = leftPosTag;
                }
            }
        } else if (slaveSet.contains(rightLemma)) {
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag = rightPosTag.replace(TAG_ANIM, ""), false);
            if (agreedPosTag == null && !leftPosTag.contains(TAG_ANIM) && MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
                agreedPosTag = leftPosTag;
            }
        } else if (slaveSet.contains(leftLemma) && (agreedPosTag = this.getAgreedPosTag(rightPosTag, leftPosTag = leftPosTag.replace(TAG_ANIM, ""), false)) == null && !rightPosTag.contains(TAG_ANIM) && MNP_ZNA_REGEX.matcher(rightPosTag).matches() && MNP_NAZ_REGEX.matcher(leftPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
            agreedPosTag = rightPosTag;
        }
        return agreedPosTag;
    }

    private static boolean isSameAnimStatus(String leftPosTag, String rightPosTag) {
        return leftPosTag.contains(TAG_ANIM) && rightPosTag.contains(TAG_ANIM) || !leftPosTag.contains(TAG_ANIM) && !rightPosTag.contains(TAG_ANIM);
    }

    private static boolean isPlural(String posTag) {
        return posTag.startsWith("noun:p:");
    }

    @Nullable
    private List<AnalyzedToken> oAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String leftBase = leftWord.substring(0, leftWord.length() - 1);
        if (!LEFT_O_ADJ.contains(leftWord.toLowerCase(this.conversionLocale)) && this.tagBothCases(leftWord).isEmpty() && this.tagBothCases(CompoundTagger.oToYj(leftWord)).isEmpty() && this.tagBothCases(leftBase).isEmpty() && this.tagBothCases(leftBase + "\u0430").isEmpty()) {
            return null;
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String oToYj(String leftWord) {
        return leftWord.endsWith("\u044c\u043e") ? leftWord.substring(0, leftWord.length() - 2) + "\u0456\u0439" : leftWord.substring(0, leftWord.length() - 1) + "\u0438\u0439";
    }

    @Nullable
    private List<AnalyzedToken> getNvPrefixNounMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.noun.getText())) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> poAdvMatch(String word, List<AnalyzedToken> analyzedTokens, String adjTag) {
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(adjTag)) continue;
            return Arrays.asList(new AnalyzedToken(word, IPOSTag.adv.getText(), word));
        }
        return null;
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase(this.conversionLocale) + word.substring(1, word.length());
    }

    private List<TaggedWord> tagBothCases(String leftWord) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        } else {
            String leftUpperCase = this.capitalize(leftWord);
            if (!leftWord.equals(leftUpperCase)) {
                leftWdList.addAll(this.wordTagger.tag(leftUpperCase));
            }
        }
        return leftWdList;
    }

    /*
     * Exception decompiling
     */
    private static Set<String> loadSet(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void debugCompounds() {
        try {
            Path unknownFile = Paths.get("compounds-unknown.txt", new String[0]);
            Files.deleteIfExists(unknownFile);
            unknownFile = Files.createFile(unknownFile, new FileAttribute[0]);
            this.compoundUnknownDebugWriter = Files.newBufferedWriter(unknownFile, Charset.defaultCharset(), new OpenOption[0]);
            Path taggedFile = Paths.get("compounds-tagged.txt", new String[0]);
            Files.deleteIfExists(taggedFile);
            taggedFile = Files.createFile(taggedFile, new FileAttribute[0]);
            this.compoundTaggedDebugWriter = Files.newBufferedWriter(taggedFile, Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void debug_compound_tagged_write(List<AnalyzedToken> guessedCompoundTags) {
        if (this.compoundTaggedDebugWriter == null || guessedCompoundTags == null) {
            return;
        }
        this.debug_tagged_write(guessedCompoundTags, this.compoundTaggedDebugWriter);
    }

    private void debug_compound_unknown_write(String word) {
        if (this.compoundUnknownDebugWriter == null) {
            return;
        }
        try {
            this.compoundUnknownDebugWriter.append(word);
            this.compoundUnknownDebugWriter.newLine();
            this.compoundUnknownDebugWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void debug_tagged_write(List<AnalyzedToken> analyzedTokens, BufferedWriter writer) {
        if (analyzedTokens.get(0).getLemma() == null || analyzedTokens.get(0).getToken().trim().isEmpty()) {
            return;
        }
        try {
            String prevToken = "";
            String prevLemma = "";
            for (AnalyzedToken analyzedToken : analyzedTokens) {
                String lemma;
                String token = analyzedToken.getToken();
                boolean firstTag = false;
                if (!prevToken.equals(token)) {
                    if (prevToken.length() > 0) {
                        writer.append(";  ");
                        prevLemma = "";
                    }
                    writer.append(token).append(" ");
                    prevToken = token;
                    firstTag = true;
                }
                if (!prevLemma.equals(lemma = analyzedToken.getLemma())) {
                    if (prevLemma.length() > 0) {
                        writer.append(", ");
                    }
                    writer.append(lemma);
                    prevLemma = lemma;
                    firstTag = true;
                }
                writer.append(firstTag ? " " : "|").append(analyzedToken.getPOSTag());
                firstTag = false;
            }
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        cityAvenue = new HashSet<String>(Arrays.asList("\u0441\u0456\u0442\u0456", "\u0430\u0432\u0435\u043d\u044e", "\u0441\u0442\u0440\u0456\u0442", "\u0448\u0442\u0440\u0430\u0441\u0441\u0435"));
        rightPartsWithLeftTagMap = new HashMap<String, Pattern>();
        ADJ_TAG_FOR_PO_ADV_MIS = IPOSTag.adj.getText() + ":m:v_mis";
        ADJ_TAG_FOR_PO_ADV_NAZ = IPOSTag.adj.getText() + ":m:v_naz";
        LEFT_O_ADJ = Arrays.asList("\u0430\u0432\u0441\u0442\u0440\u043e", "\u0430\u0434\u0438\u0433\u043e", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u043e", "\u0430\u043d\u0433\u043b\u043e", "\u0430\u0444\u0440\u043e", "\u0435\u043a\u043e", "\u0435\u0442\u043d\u043e", "\u0456\u043d\u0434\u043e", "\u0456\u0441\u043f\u0430\u043d\u043e", "\u043a\u0438\u0454\u0432\u043e", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u043e", "\u0443\u0433\u0440\u043e");
        HashMap<String, List<String>> map2 = new HashMap<String, List<String>>();
        map2.put("\u0439", Arrays.asList(":m:v_naz", ":m:v_zna", ":f:v_dav", ":f:v_mis"));
        map2.put("\u0433\u043e", Arrays.asList(":m:v_rod", ":m:v_zna", ":n:v_rod"));
        map2.put("\u043c\u0443", Arrays.asList(":m:v_dav", ":m:v_mis", ":n:v_dav", ":n:v_mis", ":f:v_zna"));
        map2.put("\u043c", Arrays.asList(":m:v_oru", ":n:v_oru", ":p:v_dav"));
        map2.put("\u0442\u0435", Arrays.asList(":n:v_naz", ":n:v_zna"));
        map2.put("\u0442\u0456", Arrays.asList(":p:v_naz", ":p:v_zna"));
        map2.put("\u0445", Arrays.asList(":p:v_rod", ":p:v_zna", ":p:v_mis"));
        NUMR_ENDING_MAP = Collections.unmodifiableMap(map2);
        rightPartsWithLeftTagMap.put("\u0431\u043e", Pattern.compile("(verb(:rev)?:impr|.*pron|noun|adv|excl|part|predic).*"));
        rightPartsWithLeftTagMap.put("\u043d\u043e", Pattern.compile("(verb(:rev)?:(impr|futr)|excl).*"));
        rightPartsWithLeftTagMap.put("\u043e\u0442", Pattern.compile("(.*pron|adv|part).*"));
        rightPartsWithLeftTagMap.put("\u0442\u043e", Pattern.compile("(.*pron|noun|adv|part|conj).*"));
        rightPartsWithLeftTagMap.put("\u0442\u0430\u043a\u0438", Pattern.compile("(verb(:rev)?:(futr|past|pres)|.*pron|noun|part|predic|insert).*"));
        dashPrefixes = CompoundTagger.loadSet("/uk/dash_prefixes.txt");
        leftMasterSet = CompoundTagger.loadSet("/uk/dash_left_master.txt");
        slaveSet = CompoundTagger.loadSet("/uk/dash_slaves.txt");
    }
}

