/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.languagetool.AnalyzedToken;

class CompoundDebugLogger {
    private static final String DEBUG_COMPOUNDS_PROPERTY = "org.languagetool.tagging.uk.UkrainianTagger.debugCompounds";
    private BufferedWriter compoundUnknownDebugWriter;
    private BufferedWriter compoundTaggedDebugWriter;
    private BufferedWriter compoundGenderMixDebugWriter;

    public CompoundDebugLogger() {
        if (Boolean.valueOf(System.getProperty(DEBUG_COMPOUNDS_PROPERTY)).booleanValue()) {
            this.initDebugCompounds();
        }
    }

    private void initDebugCompounds() {
        try {
            Path unknownFile = Paths.get("compounds-unknown.txt", new String[0]);
            Files.deleteIfExists(unknownFile);
            unknownFile = Files.createFile(unknownFile, new FileAttribute[0]);
            this.compoundUnknownDebugWriter = Files.newBufferedWriter(unknownFile, Charset.defaultCharset(), new OpenOption[0]);
            Path taggedFile = Paths.get("compounds-tagged.txt", new String[0]);
            Files.deleteIfExists(taggedFile);
            taggedFile = Files.createFile(taggedFile, new FileAttribute[0]);
            this.compoundTaggedDebugWriter = Files.newBufferedWriter(taggedFile, Charset.defaultCharset(), new OpenOption[0]);
            Path genderMixFile = Paths.get("gender-mix.txt", new String[0]);
            Files.deleteIfExists(genderMixFile);
            genderMixFile = Files.createFile(genderMixFile, new FileAttribute[0]);
            this.compoundGenderMixDebugWriter = Files.newBufferedWriter(genderMixFile, Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException ex) {
            System.err.println("Failed to open debug compounds file");
        }
    }

    public void logTaggedCompound(List<AnalyzedToken> guessedCompoundTags) {
        if (this.compoundTaggedDebugWriter == null || guessedCompoundTags == null) {
            return;
        }
        this.debug_tagged_write(guessedCompoundTags, this.compoundTaggedDebugWriter);
    }

    public void logUnknownCompound(String word) {
        if (this.compoundUnknownDebugWriter == null) {
            return;
        }
        try {
            this.compoundUnknownDebugWriter.append(word);
            this.compoundUnknownDebugWriter.newLine();
            this.compoundUnknownDebugWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void debug_tagged_write(List<AnalyzedToken> analyzedTokens, BufferedWriter writer) {
        if (analyzedTokens.get(0).getLemma() == null || analyzedTokens.get(0).getToken().trim().isEmpty()) {
            return;
        }
        try {
            String prevToken = "";
            String prevLemma = "";
            for (AnalyzedToken analyzedToken : analyzedTokens) {
                String lemma;
                String token = analyzedToken.getToken();
                boolean firstTag = false;
                if (!prevToken.equals(token)) {
                    if (prevToken.length() > 0) {
                        writer.append(";  ");
                        prevLemma = "";
                    }
                    writer.append(token).append(" ");
                    prevToken = token;
                    firstTag = true;
                }
                if (!prevLemma.equals(lemma = analyzedToken.getLemma())) {
                    if (prevLemma.length() > 0) {
                        writer.append(", ");
                    }
                    writer.append(lemma);
                    prevLemma = lemma;
                    firstTag = true;
                }
                writer.append(firstTag ? " " : "|").append(analyzedToken.getPOSTag());
                firstTag = false;
            }
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void logGenderMix(String word, boolean leftNv, String leftPosTag, String rightPosTag) {
        if (this.compoundGenderMixDebugWriter != null) {
            try {
                this.compoundGenderMixDebugWriter.append(word + " " + (leftNv ? rightPosTag : leftPosTag));
                this.compoundGenderMixDebugWriter.newLine();
                this.compoundGenderMixDebugWriter.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to write into gender mix file");
            }
        }
    }
}

