/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;

class InflectionHelper {
    static final Map<String, Integer> GEN_ORDER = new HashMap<String, Integer>();
    private static final Map<String, Integer> VIDM_ORDER = new HashMap<String, Integer>();

    private InflectionHelper() {
    }

    static List<Inflection> getAdjInflections(List<AnalyzedToken> adjTokenReadings) {
        ArrayList<Inflection> masterInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : adjTokenReadings) {
            Inflection inflection;
            String posTag = token.getPOSTag();
            if (posTag == null || !posTag.startsWith("adj")) continue;
            Matcher matcher = TokenAgreementAdjNounRule.ADJ_INFLECTION_PATTERN.matcher(posTag);
            matcher.find();
            String gen = matcher.group(1);
            String vidm = matcher.group(2);
            String animTag = null;
            if (matcher.group(3) != null) {
                animTag = matcher.group(3).substring(2);
            }
            if (masterInflections.contains(inflection = new Inflection(gen, vidm, animTag))) continue;
            masterInflections.add(inflection);
        }
        return masterInflections;
    }

    static List<Inflection> getNounInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> slaveInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            String animTag;
            String vidm;
            String gen;
            Inflection inflection;
            Matcher matcher;
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !(matcher = TokenAgreementAdjNounRule.NOUN_INFLECTION_PATTERN.matcher(posTag2)).find() || slaveInflections.contains(inflection = new Inflection(gen = matcher.group(2), vidm = matcher.group(3), animTag = matcher.group(1)))) continue;
            slaveInflections.add(inflection);
        }
        return slaveInflections;
    }

    static {
        GEN_ORDER.put("m", 0);
        GEN_ORDER.put("f", 1);
        GEN_ORDER.put("n", 3);
        GEN_ORDER.put("p", 5);
        GEN_ORDER.put("i", 6);
        GEN_ORDER.put("o", 7);
        VIDM_ORDER.put("v_naz", 10);
        VIDM_ORDER.put("v_rod", 20);
        VIDM_ORDER.put("v_dav", 30);
        VIDM_ORDER.put("v_zna", 40);
        VIDM_ORDER.put("v_oru", 50);
        VIDM_ORDER.put("v_mis", 60);
        VIDM_ORDER.put("v_kly", 70);
    }

    static class Inflection
    implements Comparable<Inflection> {
        final String gender;
        final String _case;
        final String animTag;

        Inflection(String gender, String _case, String animTag) {
            this.gender = gender;
            this._case = _case;
            this.animTag = animTag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._case == null ? 0 : this._case.hashCode());
            result = 31 * result + (this.animTag == null ? 0 : this.animTag.hashCode());
            result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Inflection other = (Inflection)obj;
            return this.genderEquals(this.gender, other.gender) && this._case.equals(other._case) && (this.animTag == null || other.animTag == null || !this.animMatters() || !other.isAnimalSensitive() || this.animTag.equals(other.animTag));
        }

        private boolean genderEquals(String gender1, String gender2) {
            if (gender1.equals(gender2)) {
                return true;
            }
            return gender1.equals("s") && gender2.matches("[mfn]") || gender2.equals("s") && gender1.matches("[mfn]");
        }

        public boolean equalsIgnoreGender(Inflection other) {
            return this._case.equals(other._case) && (this.animTag == null || other.animTag == null || !this.animMatters() || this.animTag.equals(other.animTag));
        }

        boolean animMatters() {
            return this._case.equals("v_zna") && this.isAnimalSensitive();
        }

        private boolean isAnimalSensitive() {
            return "mp".contains(this.gender);
        }

        public String toString() {
            return ":" + this.gender + ":" + this._case + (this.animMatters() ? "_" + this.animTag : "");
        }

        @Override
        public int compareTo(Inflection o) {
            int compared = GEN_ORDER.get(this.gender).compareTo(GEN_ORDER.get(o.gender));
            if (compared != 0) {
                return compared;
            }
            compared = ((Integer)VIDM_ORDER.get(this._case)).compareTo((Integer)VIDM_ORDER.get(o._case));
            return compared;
        }
    }
}

